//
// Copyright (C) Dave Roberts G8KBB 2004
//
// This is a simple demonstration of using
// the vnawrite() function via vnadll.dll
// to send a set message to the VNA.


#include "stdio.h"

#include "stdafx.h"
#include "objbase.h"
#include "iostream.h"

#include "vnaio.h"


void print_last_error_message(void);

// function takes a list of parameters.
// for example 'vnaset 0 5 32'
// waits 5msec then performs 32 back to back ADC reads.
//
// for example 'vnaset 1 0 0 0 11 22 33 44 55 66 77 88 99 00
// resets the DDS then writes 1122334455 to LOdds and 6677889900 to RFdds
// using ADC1 with an OSR value of 00
//
// for example 'vnaset 0 200 19 85 11 22 33 44 55 66 77 88 99 00
// does not reset the DDS then writes 1122334455 to LOdds and 6677889900 to RFdds
// and then waits 200 msec before performing 19 ADC conversions.
// it does this with ADC2 (the 8) with a speed (if ltc2440) of 220 Hz (OSR=5)


int main( int argc, char *argv[])
{
	VNA_TXBUFFER tx_data;
	VNADevice* VNA;				// Vector Network Analyzer hardware object
	long ltemp;
	char *tmpptr;
	int i;

	if( (argc != 5) && (argc != 15))
	{
		printf("Error: Usage is 'vnaset R ADCdel ADCcnt ADCmode [LO RF]\n");
		printf("       where R is '1' or '0' - '1' resets DDS, '0' does not\n");
		printf("       ADCdel is ADC read delay in msec - 0 to 255\n");
		printf("       ADCcnt is number of ADC reads to perform (0 to 32)\n");
		printf("       ADCmode (in hex) selects ADC (msbit) and OSR (ls 5 bits)\n");
		printf("       LO & RF if present are 5 byte hex DDS values in the form\n");
		printf("                          00 11 22 33 44 each\n");
		return false;
	}

	tx_data.cmd.command_code = 0x55;
	tx_data.cmd.flags = 0;
	i = atoi( argv[1]);
	if( i<0 || i>1 )
	{
		printf("Error - invalid DDS reset flag - read '%d', expected '0' or '1'\n", i);
		return false;
	}
	else if( i == 1 )
		tx_data.cmd.flags |= bCmdVnaSetDdsFlagsReset;

	if( argc == 15 )
		tx_data.cmd.flags |= bCmdVnaSetDdsFlagsDdsSet;

	i = atoi( argv[2]);
	if( i < 0 || i > 255 )
	{
		printf("Error - ADC delay was read as '%d' - must be between 0 and 255\n", i );
		return false;
	}
	else
		tx_data.cmd.adc_delay = i;

	i = atoi( argv[3]);
	if( i < 0 || i > 32 )
	{
		printf("Error - ADC read count was read as '%d' - must be between 0 and 32\n", i );
		return false;
	}
	else
		tx_data.cmd.adc_reads = i;

	ltemp = strtol( argv[4], &tmpptr, 16);
	if( ltemp < 0 || ltemp > 0xff )
	{
		printf("Error - ADC mode invalid (hex please!)\n" );
		return false;
	}
	else
		tx_data.cmd.adc_mode = unsigned char(ltemp);


	if( argc == 15 )
	{
		for( i=0; i<5; i++)
		{
			ltemp = strtol( argv[5+i], &tmpptr, 16);
			if( ltemp < 0 || ltemp > 255 )
			{
				printf("Invalid hex byte in LO DDS byte %d - '%s'\n", i, argv[4+i]);
				return false;
			}
			else
				tx_data.cmd.lo[i] = unsigned char(ltemp);
		}
		for( i=0; i<5; i++)
		{
			ltemp = strtol( argv[5+5+i], &tmpptr, 16);
			if( ltemp < 0 || ltemp > 255 )
			{
				printf("Invalid hex byte in RF DDS byte %d - '%s'\n", i, argv[4+5+i]);
				return false;
			}
			else
				tx_data.cmd.rf[i] = unsigned char(ltemp);
		}
	}
	else
		for(i=0; i<5; i++)
			tx_data.cmd.rf[i] = tx_data.cmd.lo[i] = 0;

	VNA = new VNADevice;

	if (VNA->get_State() != 1 )
	{
		printf("Sorry - cannot open VNA interface: ");
		print_last_error_message();
		delete VNA;
		return true;
	}


	if( VNA->Write( &tx_data, sizeof(tx_data.cmd) ) == false )
	{
		print_last_error_message();
	}
	delete VNA;
	return true;
}

void print_last_error_message()
{
	LPVOID lpMsgBuf;
	DWORD LastError;

	LastError = GetLastError();
	printf("IO Error %ld\n", LastError );
	FormatMessage( 
		FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
	    NULL,
		LastError,
	    MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
		(LPTSTR) &lpMsgBuf,
		0,
		NULL 
	);
	printf("Error message: %s\n",lpMsgBuf);
	// Free the buffer.
	LocalFree( lpMsgBuf );
}
