//
// Copyright (C) Dave Roberts G8KBB 2004
//
// This is a simple demonstration of using
// the Inp32() interface via vnadll.dll

#include "stdio.h"

#include "stdafx.h"
#include "objbase.h"
#include "iostream.h"

#include "vnaio.h"


void print_last_error_message(void);

int main( int argc, char *argv[])
{
	short value;

    value = Inp32( 0x378 );

	if( value == 0xFFFF )
		print_last_error_message();
	else
		printf("Emulated Parallel port DATA reads as 0x%02x\n", value );

    value = Inp32( 0x379 );

	if( value == 0xFFFF )
		print_last_error_message();
	else
		printf("Emulated Parallel port STATUS reads as 0x%02x\n", value );
	return true;
}

void print_last_error_message()
{
	LPVOID lpMsgBuf;
	DWORD LastError;

	LastError = GetLastError();
	printf("IO Error code %ld\n", LastError );
	FormatMessage( 
		FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
	    NULL,
		LastError,
	    MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
		(LPTSTR) &lpMsgBuf,
		0,
		NULL 
	);
	printf("IO Error message: %s\n",lpMsgBuf);
	// Free the buffer.
	LocalFree( lpMsgBuf );
}
