//
// Copyright (C) Dave Roberts G8KBB 2004
//
// This is a simple demonstration of using
// the VNADevice class via vnadll.dll
// to performa raw write via the out32() interface

#include "stdio.h"

#include "stdafx.h"
#include "objbase.h"
#include "iostream.h"

#include "vnaio.h"


void print_last_error_message(void);

int main( int argc, char *argv[])
{
	long ltemp;
	char *tmpptr;

	if( argc != 2 )
	{
		printf("Error: Usage is 'vnarawA portA ' where Port value is 2 hex digits\n");
		return false;
	}

	ltemp = strtol( argv[1], &tmpptr, 16);

	if( Out32( 0x378, (BYTE)ltemp ) == false )
		print_last_error_message();
	else
		printf("Have set port A to 0x%02x\n", (BYTE)ltemp);
	return true;
}

void print_last_error_message()
{
	LPVOID lpMsgBuf;
	DWORD LastError;

	LastError = GetLastError();
	printf("IO Error code %ld\n", LastError );
	FormatMessage( 
		FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
	    NULL,
		LastError,
	    MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
		(LPTSTR) &lpMsgBuf,
		0,
		NULL 
	);
	printf("IO Error message: %s\n",lpMsgBuf);
	// Free the buffer.
	LocalFree( lpMsgBuf );
}
