	.module		UTILS
	.globl		_EZUSB_Delay1ms, _EZUSB_Susp

;	.include /fx2regs.inc/
dps                 = 0x0086
WAKEUPCS            == 0xE682  ; Wakeup source and polarity
SUSPEND				== 0xE681

	.area UTILS (REL,CON,CODE)

_EZUSB_Delay1ms:
; Delay for 1 millisecond (1000 microseconds).
; 10 cycles * 166.6 ns per cycle is 1.66 microseconds per loop.
; 1000 microseconds / 1.66 = 602.  [assumes 24 MHz clock]
;		
		mov	a, #0			; Clear dps so that we're using dph and dpl!	
		mov	dps, a			; 
		mov	dptr,#(0x0ffff - 602) 	; long pulse for operating
		mov	r4,#5

loop:	     	inc     dptr            ; 3 cycles
		mov     a,dpl           ; 2 cycles
                orl     a,dph           ; 2 cycles
                jnz     loop		; 3 cycles
;
		ret


_EZUSB_Susp:	
        mov     dptr,#WAKEUPCS     ; TGE fx2bug - Clear the Wake Source bit(s) in
		movx	a,@dptr		     ; the WAKEUPCS register
		orl	    a,#0xC0           ; TGE fx2bug - clear PA2 and WPIN
		movx	@dptr,a

        mov     dptr,#SUSPEND    ; TGE fx2bug - new to FX2
        movx    @dptr,a          ; TGE fx2bug - write any walue to SUSPEND register

		orl	PCON,#0b00000001	     ; Place the processor in idle

		nop			             ; Insert some meaningless instruction
		nop			             ; fetches to insure that the processor
		nop			             ; suspends and resumes before RET
		nop
		nop
		ret

