//
//-----------------------------------------------------------------------------
// header file for VNA
// (C) 2004 Dave Roberts G8KBB
//
// 13 Aug 2006 - added CmdVnaSetDdsFlagsDdsSetSingleFunction
// 08 Nov 2006 - reallocated IO pins - major changes
//-----------------------------------------------------------------------------


#ifndef _VNA_H_
#define _VNA_H_

//-----------------------------------------------------------------------------
// bit definitions for IO ports
//-----------------------------------------------------------------------------
//
// PortA ADC interface
//
#define bmAdcConv		bmBIT7
#define bmAdcSerClk		bmBIT6
#define bmMagData		bmBIT5		// Input bit
#define bmPhaseData		bmBIT4		// Input bit
#define bmSpareA3		bmBIT3
#define bmSpareA2		bmBIT2
#define bmSpareA1		bmBIT1
#define bmSpareA0		bmBIT0

// PortB control port 1
//
#define bmRbwfilA2		bmBIT7              
#define bmRbwfilA1		bmBIT6              
#define bmRbwfilA0		bmBIT5				 
#define bmDataDds3Pll2	bmBIT4
#define bmDataPll3		bmBIT3
#define bmDataDds1		bmBIT2
#define bmDataPll1		bmBIT1
#define bmDataClk		bmBIT0

// Port C unused, spare

// PortD second VNA control port
//
#define bmSpareD7		bmBIT7              
#define bmInvertPDM		bmBIT6              
#define bmSpareD5		bmBIT5				 
#define bmLePll2		bmBIT4
#define bmFqUdDds3		bmBIT3
#define bmLePll3		bmBIT2
#define bmFqUdDds1		bmBIT1
#define bmLePll1		bmBIT0

// Port E unused, spare

//-----------------------------------------------------------------------------
// bit & byte definitions for messages
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
// Write Port A - E
#define CmdMsaPortAWrite				0xA0	// command in first byte of message
#define CmdMsaPortBWrite				0xA1	// command in first byte of message
#define CmdMsaPortCWrite				0xA2	// command in first byte of message
#define CmdMsaPortDWrite				0xA3	// command in first byte of message
#define CmdMsaPortEWrite				0xA4	// command in first byte of message
#define CmdMsaPortReset					0xA5	// reset all IO lines
#define CmdMsaPortRawWrite				0xA6	// write selectively to all ports

// byte offsets for commands A0 - A4
#define CmdMsaPortWriteByteCount	1		// number of bytes to write
#define CmdMsaPortWriteClock		2		// offset to bytes to write
#define CmdMsaPortWriteByteOfs		3		// offset to bytes to write
#define CmdMsaPortWriteMinSize		4		// messages must be at least 4 bytes long

// byte offsets for command A5
#define CmdMsaPortResetMinSize		1		// message carries no bytes beyong command (A5)

// byte offsets for command A6
#define CmdMsaPortRawWriteFlags		1		// flags b0 = A, b1 = B, b2=C, b3=D, b4=E
#define CmdMsaPortRawWritePortA		2		// if flags bit 0 set write this value to port A
#define CmdMsaPortRawWritePortB		3		// if flags bit 1 set write this value to port B
#define CmdMsaPortRawWritePortC		4		// if flags bit 2 set write this value to port C
#define CmdMsaPortRawWritePortD		5		// if flags bit 3 set write this value to port D
#define CmdMsaPortRawWritePortE		6		// if flags bit 4 set write this value to port E
#define CmdMsaPortWriteRawMinSize	7		// messages must be at least 7 bytes long

//-----------------------------------------------------------------------------
// ADC read commands
// for LT1860 use ClockOptions = 1, ClockDelay = 2, bits = 12
// for AD7685 use ClockOptions = 0, ClockDelay = 0, bits = 0x10 
//
// delay is approx 2.6 + (ClockDelay*0.0.585) usec for phase+mag conversion
// and 3.6 + (ClockDelay*0.0.585) usec for phase or magniture alone
//
// A TYPICAL COMMAND TO READ MAGNITUDE FOR AD7685 WOULD BE: B0 00 01 10 01
// A TYPICAL COMMAND TO READ MAGNITUDE FOR LT1860 WOULD BE: B0 01 02 0C 01
//
// Where the bytes are:
//		B0 - command byte (B0 = read magnitude only)
//		01 - clock option 1 for LT1860
//		02 - delay 4.8 us (a bit on the generous side to be careful)
//		0C - read 12 bits
//		01 - make just one ADC reading, no averaging
// 
//
#define CmdMsaReadMagAdc				0xB0	// command in first byte of message
#define CmdMsaReadPhaseAdc				0xB1	
#define CmdMsaReadBothAdc				0xB2
#define CmdMsaReadClockOptions		1		// byte offset into message - clocking
#define CmdMsaReadClockDelay		2		// byte offset into message - convert delay
#define CmdMsaReadBits				3		// byte offset into message - number of bits
#define CmdMsaReadAverage			4		// byte offset into message - number of readings to average
#define CmdMsaReadMinSize			5		// byte offset into message - number of readings to average
// clock options
#define CmdMsaReadClockAD7865		0
#define CmdMsaReadClockLT1860		1

//-----------------------------------------------------------------------------
// bit definitions for ReturnStatus
//-----------------------------------------------------------------------------

//#define AdcReadTimeout         bmBIT7              // attempt to read ADC timed out
//#define VnaNoPower             bmBIT6              // The VNA appears not to be powered up
#define AdcDataReady           bmBIT5              // ADC data is available
//#define AdcStartFlag           bmBIT4              // set when ADC read is pending
#define AdcNotResponding       bmBIT3              // SDO was not high immediately after start
//#define I2CLastOpFailed		   bmBIT2			   // I2C read/write status from last call
//#define I2CDataReady		   bmBIT1			   // I2C Data is Available
//-----------------------------------------------------------------------------
// Parallel port driver version definitions
//-----------------------------------------------------------------------------
// If the parallel port option for driving a slim CB is used, these are the 
// "real" port definitions and the ones states above are "virtual" port
// definitions 
// commands A0-A5 write to virtual ports
// command A6 writes to real port

// bit definitions for data as as per ports B and D above
#define Parallel_data	IOB
// bit definitions for port D are as below (these strobe the data)
#define Parallel_ctrl	IOD
// bit definitions for port A are as per port A above (ADC input)
#define Parallel_adc	IOA

// PORT D bit functions
// for SELT, strobe data to port 1 ( virtual Port B)
// for INIT, strobe data to port 2 ( virtual Port D)
// for AUTO, strobe data to port 3 ( virtual Port A)
// for STRB, strobe data to port 4 ( virtual Port C)
// for xtra, strobe data to port x ( virtual Port E)
#define Parallel_selt	bmBIT0
#define Parallel_init	bmBIT1
#define Parallel_auto	bmBIT2
#define Parallel_strb	bmBIT3
#define Parallel_xtra	bmBIT4

// 
//-----------------------------------------------------------------------------
// Miscellaneous definitions
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// function prototypes
//-----------------------------------------------------------------------------
void AdcTimeout();

#endif // _VNA_H_


