; /*-------------------------------------------------------------------------
; 
;   crtstart.asm :- C run-time: startup                
; 
;    This library is free software; you can redistribute it and/or modify it
;    under the terms of the GNU Library General Public License as published by the
;    Free Software Foundation; either version 2, or (at your option) any
;    later version.
;    
;    This library is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU Library General Public License for more details.
;    
;    You should have received a copy of the GNU Library General Public License
;    along with this program; if not, write to the Free Software
;    Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;    
;    In other words, you are welcome to use, share and improve this program.
;    You are forbidden to forbid anyone else to use, share and improve
;    what you give them.   Help stamp out software-hoarding!  
; -------------------------------------------------------------------------*/

	.area CSEG    (CODE)
	.area GSINIT0 (CODE)
	.area GSINIT1 (CODE)
	.area GSINIT2 (CODE)
	.area GSINIT3 (CODE)
	.area GSINIT4 (CODE)
	.area GSINIT5 (CODE)
	.area GSINIT  (CODE)
	.area GSFINAL (CODE)

	.globl __start__stack
	
	.area GSINIT0 (CODE)

__sdcc_gsinit_startup::
        mov     sp,#__start__stack - 1

	.area GSINIT2 (CODE)
	
        lcall   __sdcc_external_startup
        mov     a,dpl
        jz      __sdcc_init_data
        ljmp    __sdcc_program_startup
__sdcc_init_data:

	.module     USBJmpTbl
	
	.globl      USB_Int2AutoVector, USB_Int4AutoVector, USB_Jump_Table
; extrn code (ISR_Sudav, ISR_Sof, ISR_Sutok, ISR_Susp, ISR_Ures, ISR_Highspeed)
;	.globl ISR_Sudav, ISR_Sof, ISR_Sutok, ISR_Susp, ISR_Ures, ISR_Highspeed

;------------------------------------------------------------------------------
; Interrupt Vectors
;------------------------------------------------------------------------------
	.area USBJmpTb (ABS)
;	.org 0
;	ljmp	__sdcc_program_startup
;	
	.org 0x43
;      CSEG   AT 43H
USB_Int2AutoVector   =   . + 2
      ljmp   USB_Jump_Table   ; Autovector will replace byte 45

 	.org 0x53
;     CSEG   AT 53H
USB_Int4AutoVector   =   . + 2
      ljmp   USB_Jump_Table   ; Autovector will replace byte 55

;------------------------------------------------------------------------------
; USB Jump Table
;------------------------------------------------------------------------------
	.area USB_JUMP_TABLE (ABS)
	.org 0x0100
;;?PR?USB_JUMP_TABLE?USBJT   segment   code page   ; Place jump table on a page boundary
;;      RSEG    ?PR?USB_JUMP_TABLE?USBJT   ; autovector jump table
USB_Jump_Table:   
      ljmp  ISR_Sudav            ;(00) Setup Data Available
      .db   0
      ljmp  ISR_Sof              ;(04) Start of Frame
      .db   0
      ljmp  ISR_Sutok            ;(08) Setup Data Loading
      .db   0
      ljmp  ISR_Susp             ;(0C) Global Suspend
      .db    0
      ljmp  ISR_Ures             ;(10) USB Reset     
      .db   0
      ljmp  ISR_Highspeed        ;(14) Entered High Speed
      .db   0
      ljmp  ISR_Ep0ack           ;(18) EP0ACK
      .db   0
      ljmp  ISR_Stub             ;(1C) Reserved
      .db   0
      ljmp  ISR_Ep0in            ;(20) EP0 In
      .db   0
      ljmp  ISR_Ep0out           ;(24) EP0 Out
      .db   0
      ljmp  ISR_Ep1in            ;(28) EP1 In
      .db   0
      ljmp  ISR_Ep1out           ;(2C) EP1 Out
      .db   0
      ljmp  ISR_Ep2inout         ;(30) EP2 In/Out
      .db   0
      ljmp  ISR_Ep4inout         ;(34) EP4 In/Out
      .db   0
      ljmp  ISR_Ep6inout         ;(38) EP6 In/Out
      .db   0
      ljmp  ISR_Ep8inout         ;(3C) EP8 In/Out
      .db   0
      ljmp  ISR_Ibn              ;(40) IBN
      .db   0
      ljmp  ISR_Stub             ;(44) Reserved
      .db   0
      ljmp  ISR_Ep0pingnak       ;(48) EP0 PING NAK
      .db   0
      ljmp  ISR_Ep1pingnak       ;(4C) EP1 PING NAK
      .db   0
      ljmp  ISR_Ep2pingnak       ;(50) EP2 PING NAK
      .db   0
      ljmp  ISR_Ep4pingnak       ;(54) EP4 PING NAK
      .db   0
      ljmp  ISR_Ep6pingnak       ;(58) EP6 PING NAK
      .db   0
      ljmp  ISR_Ep8pingnak       ;(5C) EP8 PING NAK
      .db   0
      ljmp  ISR_Errorlimit       ;(60) Error Limit
      .db   0
      ljmp  ISR_Stub             ;(64) Reserved
      .db   0
      ljmp  ISR_Stub             ;(68) Reserved
      .db   0
      ljmp  ISR_Stub             ;(6C) Reserved
      .db   0
      ljmp  ISR_Ep2piderror      ;(70) EP2 ISO Pid Sequence Error
      .db   0
      ljmp  ISR_Ep4piderror      ;(74) EP4 ISO Pid Sequence Error
      .db   0
      ljmp  ISR_Ep6piderror      ;(78) EP6 ISO Pid Sequence Error
      .db   0
      ljmp  ISR_Ep8piderror      ;(7C) EP8 ISO Pid Sequence Error
      .db   0
;INT4_Jump_Table
      ljmp  ISR_Ep2pflag         ;(80) EP2 Programmable Flag
      .db   0
      ljmp  ISR_Ep4pflag         ;(84) EP4 Programmable Flag
      .db   0
      ljmp  ISR_Ep6pflag         ;(88) EP6 Programmable Flag
      .db   0
      ljmp  ISR_Ep8pflag         ;(8C) EP8 Programmable Flag
      .db   0
      ljmp  ISR_Ep2eflag         ;(90) EP2 Empty Flag
      .db   0
      ljmp  ISR_Ep4eflag         ;(94) EP4 Empty Flag
      .db   0
      ljmp  ISR_Ep6eflag         ;(98) EP6 Empty Flag
      .db   0
      ljmp  ISR_Ep8eflag         ;(9C) EP8 Empty Flag
      .db   0
      ljmp  ISR_Ep2fflag         ;(A0) EP2 Full Flag
      .db   0
      ljmp  ISR_Ep4fflag         ;(A4) EP4 Full Flag
      .db   0
      ljmp  ISR_Ep6fflag         ;(A8) EP6 Full Flag
      .db   0
      ljmp  ISR_Ep8fflag         ;(AC) EP8 Full Flag
      .db   0
      ljmp  ISR_GpifComplete     ;(B0) GPIF Operation Complete
      .db   0
      ljmp  ISR_GpifWaveform     ;(B4) GPIF Waveform
      .db   0


;ISR_Sudav:            ;(00) Setup Data Available
;ISR_Sof:              ;(04) Start of Frame
;ISR_Sutok:            ;(08) Setup Data Loading
;ISR_Susp:             ;(0C) Global Suspend
;ISR_Ures:             ;(10) USB Reset     
;ISR_Highspeed:        ;(14) Entered High Speed
ISR_Ep0ack:           ;(18) EP0ACK
ISR_Stub:             ;(1C) Reserved
ISR_Ep0in:            ;(20) EP0 In
ISR_Ep0out:           ;(24) EP0 Out
ISR_Ep1in:            ;(28) EP1 In
ISR_Ep1out:           ;(2C) EP1 Out
ISR_Ep2inout:         ;(30) EP2 In/Out
ISR_Ep4inout:         ;(34) EP4 In/Out
ISR_Ep6inout:         ;(38) EP6 In/Out
ISR_Ep8inout:         ;(3C) EP8 In/Out
ISR_Ibn:              ;(40) IBN
;ISR_Stub:             ;(44) Reserved
ISR_Ep0pingnak:       ;(48) EP0 PING NAK
ISR_Ep1pingnak:       ;(4C) EP1 PING NAK
ISR_Ep2pingnak:       ;(50) EP2 PING NAK
ISR_Ep4pingnak:       ;(54) EP4 PING NAK
ISR_Ep6pingnak:       ;(58) EP6 PING NAK
ISR_Ep8pingnak:       ;(5C) EP8 PING NAK
ISR_Errorlimit:       ;(60) Error Limit
;ISR_Stub:             ;(64) Reserved
;ISR_Stub:             ;(68) Reserved
;ISR_Stub:             ;(6C) Reserved
ISR_Ep2piderror:      ;(70) EP2 ISO Pid Sequence Error
ISR_Ep4piderror:      ;(74) EP4 ISO Pid Sequence Error
ISR_Ep6piderror:      ;(78) EP6 ISO Pid Sequence Error
ISR_Ep8piderror:      ;(7C) EP8 ISO Pid Sequence Error
;INT4_Jump_Table
ISR_Ep2pflag:         ;(80) EP2 Programmable Flag
ISR_Ep4pflag:         ;(84) EP4 Programmable Flag
ISR_Ep6pflag:         ;(88) EP6 Programmable Flag
ISR_Ep8pflag:         ;(8C) EP8 Programmable Flag
ISR_Ep2eflag:         ;(90) EP2 Empty Flag
ISR_Ep4eflag:         ;(94) EP4 Empty Flag
ISR_Ep6eflag:         ;(98) EP6 Empty Flag
ISR_Ep8eflag:         ;(9C) EP8 Empty Flag
ISR_Ep2fflag:         ;(A0) EP2 Full Flag
ISR_Ep4fflag:         ;(A4) EP4 Full Flag
ISR_Ep6fflag:         ;(A8) EP6 Full Flag
ISR_Ep8fflag:         ;(AC) EP8 Full Flag
ISR_GpifComplete:     ;(B0) GPIF Operation Complete
ISR_GpifWaveform:     ;(B4) GPIF Waveform
	RETI



;;      end
