/*****************************************************************************/
/*	         							     */
/*									     */
/*    *****			  ***** 				     */
/*	 *****			*****					     */
/*	   *****	      *****					     */
/*	     *****	    *****					     */
/*  ***************	  ***************				     */
/*  *****************	*****************				     */
/*  ***************	  ***************				     */
/*	     *****	    *****	   TheNet       		     */
/*	   *****	      *****	   Portable. Compatible.	     */
/*	 *****			*****	   Public Domain		     */
/*    *****			  *****    NORD><LINK	 		     */
/*									     */
/* This software is public domain ONLY for non commercial use                */
/*                                                                           */
/*									     */
/*****************************************************************************/

/* Level 7B, Befehlsinterpreter, Befehle				     */
/* Version 1.01  							     */
/* Hans Georg Giese, DF2AU, Hinter dem Berge 5, 3300 Braunschweig	     */
/* 08-MAY-88								     */

/* Modified by G8KBB - Jan 91 						     */
/*      - conditionally exclude ccpcq() if NOCQ is defined                   */
/*      - disable downlink connects if NODOWNLINK is defined                 */
/*      - Use of register keyword for code reduction                         */
/*      - replace seades() by iscall() - function name change !              */
/*      - Use all.h header file                                              */
/*      - add a polite error if CQ not enabled                               */
/*      - give error msg in 'nodes' cmd when node name not recognised        */
/*        and do it conditionally on MODIFIED                                */
/*      - conditionally, put front-end to connect to trap 'c' with no dest   */
/*      - conditionally, include MODE command and reuse common code in PARAM */
/*      - make reset do cold or warmstart conditionally on parameter given   */
/*      - move common code from LOW and HIGH commands to one routine         */
/*      - correct bug in ccpide() conditionally on MODIFIED                  */
/*      - make connect with no parameters go to BBS or HOST on ctobbs setting*/
/*      - conditionally exclude HI and LOW commands on NOHILOW               */
/*      - Add connect in progress info message to user                       */
/*      - Add ACL functions into connect command                             */
/*      - Remove spurious '== 1' and similar constructs to simplify          */
/*      - Add digipeat downlink control into connect command                 */

/* This half of the command interpreter functions contains the following
 * commands :
 *     Connect        CQ         Ident       Nodes        Parms
 *     Mode           MTU        Meter       Routes       Reset
 *     Low            High       Sysop       Users
 */

/*
 * September 1993 - released as TheNet X-1J
 */

#include "all.h"
#include "tntyp.h"		/* Definition der Typen			     */
#include "tnl7be.h"		/* externe Definitionen			     */

char noconnect[] = "Cannot connect. Sorry.";
char linktxt[] = "Link";

/*---------------------------------------------------------------------------*/
VOID	ccpcon()		/* CONNECT Befehl			     */
#ifdef MODIFIED			/* conditionally, put filter in front of 'C' */
{				/* command to bar it by sysop but let the    */
  if( clicnt == 0 )		/* also, if no parameter is given to connect */
  {
    switch( ctobbs )
    {
      case 0:
            ccphst();	/* do the 'host' command                     */
            break;
      case 1:
            ccpbbs();	/* do the BBS command                        */
            break;
      case 2:
            ccpdxc();   /* do the DXcluster command */
            break;
      default:
            ccp_con();
    }
  }
  else
  	ccp_con();		/* else do the original 'connect' command !  */
}

ccp_con()			/* original connect command renamed ccp_con()*/
#endif
  {
  char	   call[7];		/* User Call				     */
  char	   digil[57];		/* Downlink Digiliste			     */
  char	   node[6];		/* Ziel Node				     */
  char	   *cpoisa;		/* Temp fuer clipoi			     */
  unsigned ccntsa;		/* Temp fuer clicnt			     */
  unsigned is_call;		/* Ergebniss der Suche nach Call	     */
  unsigned isnode;		/* Ergebniss der Suche nach Node	     */
  register unsigned cnt;	/* Scratch Zaehler			     */
  register usrtyp   *usrpoi;	/* aktueller User beim Suchen		     */
  l2ltyp   *frelnk;		/* freier lnkpoi Platz			     */
  register l2ltyp   *p_cblk;	/* Partner lnkpoi Block			     */

  if (!ismemr()) return;	/* noch Platz? 				     */


  if (clicnt != 0)		/* ohne Parameter -> Host connecten	     */
   {
    cpoisa = clipoi;		/* Parameter des Aufrufs retten		     */
    ccntsa = clicnt;
    isnode = getide(node);	/* Node angegeben?			     */
    clipoi = cpoisa;		/* Aufrufparameter zurueck		     */
    clicnt = ccntsa;

    if (
       (((is_call = ((getcal(&clicnt, &clipoi, VCpar, call) == 1) &&
                    (getdig(&clicnt, &clipoi, 0, digil) != -1))
                    ) /* == 1 */)
        && (digil[0] == 0)
        && (iscall(call) == 1))
        || ((isnode == 1) && (isidnt(node) /* == 1*/ )))
       {

/*=== Node soll connected werden ============================================*/
        for (cnt = 0, cirpoi = cirtab; cnt < NUMCIR; ++cnt, ++cirpoi)
         {				/* freien Platz in CIRTAB suchen     */
          if (cirpoi->state3 == 0) break;
         }
#ifdef ACL
        if( (acl_mask & ACL_BAR_L4_OG ) &&
            (acl_entry( despoi->nodcal ) & ACL_BAR_L4_OG ))
          putmsg(noconnect);
      else
#endif
        if (cnt != NUMCIR )		/* Erfolg dabei?		     */
         {
          userpo->cblk_p = (l2ltyp *) cirpoi;	/* in User Block eintragen   */
          userpo->typ_p = 4;		/* und Usertyp eintragen	     */
          userpo->status = 2;		/* Staus: connect requested	     */
          cpyid(cirpoi->downca, despoi->nodcal);
          cpyid(cirpoi->upcall, usrcal);/* User Call merken		     */
          cirpoi->l3node = despoi;	/* CIRTAB Eintrag mit Userdaten	     */
          newcir();			/* Circuit aufbauen		     */
         }
        else puttfu("Circuit");		/* kein Platz: melden		     */
        return;
       }

/*=== User soll connected werden ============================================*/
    if (is_call == 1)			/* gueltiges Call?		     */
     {
#ifdef NODOWNLINK
	putmsg("Downlink is not possible from this switch\15");
#else
					/* Antwort auf CQ-Ruf?		     */
      for (usrpoi = (usrtyp *) usccpl.lnext;
           (usrtyp *) &usccpl != usrpoi;
            usrpoi = usrpoi->unext)
       {				/* Userliste absuchen		     */
        if ((usrpoi->status == 2)	/* Status muss stimmen		     */
          &&(usrpoi->typ_p == 2)	/* gesuchter Partner muss stimmen    */
          &&((p_cblk = usrpoi->cblk_p)->state == 0)) /* und noch kein L2     */
         {
         if (cmpid(p_cblk->srcid, call) /*== 1*/) /* und eigenes Call	     */
          {
           disusr(p_cblk, 2);		/* dann aus CCP entfernen	     */
           for (ptcrdp = ptcrdl; ptcrdp->luserl != 0; ptcrdp += 2)
            ;				/* freier Eintrag links		     */
           makcon(usrpoi);		/* Verbindung herstellen	     */
           ++ptcrdp;			/* auf rechte Seite		     */
           frelnk = (l2ltyp *) userpo;
           userpo = usrpoi;
           makcon(usrpoi = (usrtyp *) frelnk);	/* zweite Seite              */
           kilusr();			/* Partner loeschen		     */
           userpo = usrpoi;
           kilusr();			/* eigenen Eintrag loeschen	     */
           return;
          }
         }
       }
                                        /* Connect in L2 absetzen	     */
      invsid();				/* SSID aendern			     */
      for (p_cblk = 0, cnt = 0, lnkpoi = lnktbl; /* freien Eintrag finden    */
           cnt < MAXL2L; ++cnt, ++lnkpoi)
       {
        if (lnkpoi->state != 0)		/* Eintrag leer?		     */
         {
          if ((cmpid(lnkpoi->srcid, usrcal) /* == 1 */ )
            && (cmpid(lnkpoi->dstid, call) /* == 1 */ ))
           {
            msgfrm('D', lnkpoi, 2, dmmsg); /* nicht gleiche Partner 2-mal    */
            return;
           }
         }
        else				/* leerer Eintrag gefunden:	     */
         {
          if ((! p_cblk) && (lnkpoi->srcid[0] == 0))
           p_cblk = lnkpoi;		/* den ersten merken		     */
         }
        }
#ifdef ACL
      if( (acl_mask & ACL_BAR_L2_OG) && (acl_entry( call ) & ACL_BAR_L2_OG ))
          putmsg(noconnect);
      else
#endif
#ifdef MODIFIED
      if( ( no_digi & 2 ) && *digil )
          putmsg("Sorry - no digi");
      else
#endif
      if (p_cblk != 0) {		/* freier Platz da?		     */
        lnkpoi = p_cblk;		/* merken			     */
        setl2b();			/* L2 Block initialisieren	     */
        cpyid(lnkpoi->dstid, call);	/* Partner Call			     */
        cpyidl(lnkpoi->viaid, digil);	/* Digipeater			     */
        lnkpoi->liport = 0;		/* Port ist HDLC		     */
        newlnk();			/* an Level2 melden		     */
        }
      else {				/* alles voll			     */
        puttfu( linktxt );			/* melden			     */
        }
#endif
    }
    else invcal();
    return;
    }

/*=== Host soll connected werden ============================================*/
  for (cnt = 0, hstusr = hstubl;	/* alle Hostkanaele absuchen	     */
       cnt < MAXHST;
       ++cnt, ++hstusr) {
    if (! hstusr->conflg)		/* dieser Kanal belegt?		     */
      break;
    }
  if (cnt != MAXHST) {			/* freien Kanal gefunden?	     */
    userpo->cblk_p = (l2ltyp *) hstusr;		/* Host als Partner eintragen*/
    userpo->typ_p = 0;			/* Usertyp ist Host		     */
    userpo->status = 2;			/* neuer Status: connect requested   */
    cpyid(hstusr->call, usrcal);	/* Usercall in Hostblock eintragen   */
    hstreq();				/* Request an Hostinterface leiten   */
    return;
    }
  else puttfu("Host");			/* kein Kanal frei		     */
}

#ifndef NOCQ
/*---------------------------------------------------------------------------*/
ccpcq()				/* CQ-Ruf starten			     */
  {
  register unsigned cnt;		/* Scartch Zaehler		     */
  register mhtyp    *mbhd;		/* Buffer fuer Meldung		     */

  if (ismemr() /* == 1 */)		/* Platz genug?			     */
   {
    for (cnt = 0, lnkpoi = lnktbl; cnt < MAXL2L; ++cnt, ++lnkpoi)
     {					/* freien Platz in L2-Liste suchen   */
      if ((lnkpoi->state == 0) && (lnkpoi->srcid[0] == 0))
        break;
     }
    if (cnt < MAXL2L)
     {
      invsid();				/* SSID umdrehen		     */
      setl2b();				/* L2 Kontrollblock initialisieren   */
      if (cqen /* == 1 */)		/* CQ-Ruf zulaessig?		     */
       {
        (mbhd = (mhtyp *) allocb())->pid = PID_NO_L3;	/* PID setzen	     */
        while (clicnt != 0)		/* Rest der Zeile ist Meldung	     */
         {
          putchr(*clipoi, mbhd);	/* umkopieren			     */
          nxtcli();
         }
        putchr(0x0d, mbhd);		/* Zeilenende anhaengen		     */
        rwndmb(mbhd);			/* Pointer auf Null		     */
        sdui(cqdil, cqdest, usrcal, 0, mbhd); /* senden			     */
        dealmb(mbhd);			/* Buffer wieder freigeben	     */
       }
      else
          putmsg("Sorry, CQ is not enabled");	/* Error message     */
     }
    else				/* Tabelle ist voll		     */
      puttfu( linktxt );			/* melden			     */
   }
  }
#endif

/*---------------------------------------------------------------------------*/
VOID	ccpide()		/* Befehl INFO				     */
{
  register mhtyp *bufpoi;			/* Buffer fuer Meldung	     */
  register unsigned chaptr;

#ifdef MODIFIED
  settxt( infmsg, 159 );
#else
  if (issyso() == TRUE)				/* Sysop setzt Zusatz?	     */
   {
    chaptr = 0;
    while (clicnt != 0)
     {
      infmsg[chaptr++] = *clipoi;
      nxtcli();
      if( chaptr == 159 )		/* if max length of infmsg is reached*/
          break;			/* then stop storing.                */
     }
    infmsg[chaptr] = 0;
   }
#endif

  bufpoi = putals(DEFINF);			/* Info mit Header	     */
  putchr('\015', bufpoi);
  putstr(infmsg, bufpoi);			/* Zusatzinfo		     */
  seteom(bufpoi);				/* Endekennung dran	     */
  }

/*---------------------------------------------------------------------------*/
VOID	ccpnod()		/* NODES Befehl				     */
  {
  char	   newcal[7];		/* neues Call				     */
  char	   niden[6];		/* neuer Ident				     */
  char     *cpoisa;		/* temp fuer clipoi			     */
  BOOLEAN  alles;		/* versteckte Nodes auch zeigen		     */
  unsigned nobc;		/* neuer Abwesenheitszaehler		     */
  unsigned wegcnt;		/* Zaehler fuer Wege in Ausgabe		     */
  unsigned aender;		/* Aenderungsmode: + oder -		     */
  register unsigned is_call;	/* Ergebniss des Tests auf gueltiges Call    */
  register unsigned isnode;	/* Ergebniss des Tests auf gueltigen Node    */
  unsigned ccntsa;		/* temp fuer clicnt			     */
  BOOLEAN  neupar;		/* neue Parameter in der Zeile		     */
  unsigned cnt;			/* Scratch Zaehler			     */
  unsigned leer;		/* Leerzeichen bis zum naechsten Node	     */
  register mhtyp *bufpoi;	/* Buffer fuer Meldung an User		     */
  wegtyp   *actweg;		/* aktueller Weg der Ausgabe		     */
  nbrtyp   *nabar;		/* Nachbar fuer aktuellen Node		     */

  alles = FALSE;		/* default: keine versteckten Nodes	     */
  if (clicnt != 0)		/* mit Argument aufgerufen?	   	     */
   {
    cpoisa = clipoi;		/* Befehlszeile retten		   	     */
    ccntsa = clicnt;
    isnode = getide(niden);	/* Test auf Node Namen			     */
    clipoi = cpoisa;		/* Befehlszeile zurueck			     */
    clicnt = ccntsa;
#ifdef MODIFIED
    is_call = getcal(&clicnt, &clipoi, 1, newcal); /* Test auf Call	     */
#else
    is_call = getcal(&clicnt, &clipoi, VCpar, newcal); /* Test auf Call	     */
#endif
    clipoi = cpoisa;		/* Befehlszeile zurueck			     */
    clicnt = ccntsa;

    while (clicnt != 0)
     {
      if (*clipoi == ' ') break;
      nxtcli();
     }

    if ((is_call == 1)		/* alle Nodes oder was spezielles gefragt?   */
      || (isnode != -1))
     {
      neupar = FALSE;			/* default: keine neuen Parameter    */
      if ((issyso() /* == 1 */)		/* nur Sysop darf aendern	     */
        && (is_call == 1))		/* wenn er ein Call angibt	     */
       {
        --clicnt;			/* Aenderungsmode uebergehen	     */
        if (((aender = *clipoi++) == '+') /* nur + oder - erlaubt	     */
          || (aender == '-'))
         {

/*=== Node Parameter aendern ================================================*/
          if ((skipspace() /* == 1*/ ) /* Parameter holen	     */
            && ((isnode = getide(niden)) != -1)) /* Ident		     */
           {
            if (getqua() /* == 1 */)		/* Qualitaet holen	     */
             {
              if ((skipspace() /* == 1 */)
              && ((nobc = nextnumber() ) <= 255))
               {
                if (getpar() /* == 1 */) 
                   neupar = TRUE; 		/* Port, Digis, Nachbar    */
               }
             }
           }
         }
       }
      else if (isnode == 0) alles = 1; /* Sternchen eingegeben		     */

      if (neupar /* == TRUE */) {		/* neue Werte spezifiziert   */
        if (chgnod(aender, nobc, nquali, nport, ndigi, ncall, niden, newcal)
            == 0) {
          puttfu("Routing");		/* hat nicht geklappt, Ende	     */
          return;
          }
        }
      if (((is_call == TRUE) && (iscall(newcal) /* == 1 */)) /*gueltiges Call*/
       || ((isnode == TRUE) && (isidnt(niden) /* == 1*/))) { /* Node?	     */
        putnod(bufpoi = putals("Routes to: ")); /* gueltig:		     */

        for (wegcnt = 0; wegcnt < despoi->wege; ++wegcnt)
         {				/* alle Wege zeigen		     */
          nabar = (actweg = &despoi->weg[wegcnt])->nachba;
          putstr((((despoi->actrou != 0) && (despoi->wegnr == wegcnt)) ?
            "\015> " : "\015  "), bufpoi); /* aktiven Weg markieren	     */
#ifdef MODIFIED
          putnum_and_space((actweg->qualit) &0xff, bufpoi);
#else
          putnum((actweg->qualit) &0xff, bufpoi);
          putchr(' ', bufpoi);
#endif
          putnum((actweg->obscnt) &0xff, bufpoi);
          putnbr(nabar, bufpoi);	/* Nachbarn Zeigen		     */
         }

        seteom(bufpoi);			/* Ende anhaengen		     */
        return;
        }
#ifdef MODIFIED
        else if( alles == FALSE ) 		/* if node requested    */
        {					/* that is not known,   */
            putmsg("Unknown node." ); 		/* then give an error   */
            return;				/* rather than nodes    */
        }
#endif
      }
    }

/*=== Nodes anzeigen ========================================================*/
  bufpoi = putals("Nodes:");		/* Kopfzeile holt Buffer	     */
  cnt = 0;				/* Nummer des Eintrages		     */
  for (despoi = (nodtyp *) destil.lnext;		/* gesamte Liste		     */
       (nodtyp *) &destil != despoi;
       despoi = (nodtyp *) despoi->nodlnk.lnext) {
    if (despoi->nodcal[0] != 0) {	/* Eintrag definiert?		     */
      if (
           ((despoi->nodide[0] != '#') || (alles /*== TRUE*/))
#ifdef MODIFIED
           && (( no_slime & 1 ) == 0 || despoi->nodide[0] != ' ' )
#endif
         ) 				/* auch versteckte Nodes zeigen?     */
      {		
#ifdef MODIFIED
        if( clicnt && *clipoi == '*' )
        {
          putchr('\015', bufpoi);
          bufpoi->l4time = bufpoi->putcnt;
          putnod(bufpoi); /* gueltig:		     */
          putspa(17, bufpoi);		/* Abstand zum Nachbarn		     */
          for (wegcnt = 0; wegcnt < despoi->wege; ++wegcnt)
          {				/* alle Wege zeigen		     */
            if( wegcnt > 0 )
              putspa(22, bufpoi);	/* Abstand zum Nachbarn		     */
            bufpoi->l4time = bufpoi->putcnt;
            nabar = (actweg = &despoi->weg[wegcnt])->nachba;
            putstr((((despoi->actrou != 0) && (despoi->wegnr == wegcnt)) ?
              "> " : "  "), bufpoi); /* aktiven Weg markieren	     */
            putnum_and_space((actweg->qualit) &0xff, bufpoi);
            putnum_and_space((actweg->obscnt) &0xff, bufpoi);
            putnum_and_space((nabar->nbrpor) &0xff, bufpoi);
            putid(nabar->nbrcal, bufpoi);	/* Nachbarn Zeigen		     */
          }
        }
        else
        {
#endif
        if ((cnt++ & 0x03) == 0)	/* 4 Nodes in eine Zeile	     */
          putchr('\015', bufpoi);
        bufpoi->l4time = bufpoi->putcnt;
        putnod(bufpoi);			/* Node ausgeben		     */
        putspa(19, bufpoi);		/* Abstand zum Nachbarn		     */
#ifdef MODIFIED
       }
#endif
    } } }
  seteom(bufpoi);			/* Endekennung anhaengen	     */
  }

/*---------------------------------------------------------------------------*/
#ifdef MODIFIED
/*
 * move the param code to a common routine to allow Param and Mode to share it
 */

VOID ccppar()
{
	ccp_par( partab, (sizeof(partab) / sizeof(struct param)));
}

VOID ccpmod()
{
	ccp_par( modtab, (sizeof(modtab) / sizeof(struct param)));
}

#ifdef MANAGED
VOID ccpaud()
{
	ccp_par( audtab, (sizeof(audtab) / sizeof(struct param)));
}
#endif

#ifdef MOD_MTU
VOID ccpmtu()
{
	ccp_par( mtutab, (sizeof(mtutab) / sizeof(struct param)));
}
#endif

#ifdef METERS
VOID ccpmet()
{
	ccp_par( mettab, (sizeof(mettab) / sizeof(struct param)));
}
#endif

#ifdef PK96
VOID ccpbra()
{
	ccp_par( bratab, (sizeof(bratab) / sizeof(struct param)));
}
#endif

VOID	ccp_par(table, tablesize)		/* PARMS Befehl				     */
partyp *table;
unsigned tablesize;
  {
  unsigned laenge;		/* Laenge der Zeile bisher		     */
  register unsigned newval;	/* neuer Wert des Parameters		     */
  unsigned parnum;		/* Nummer des aktuellen Parameters	     */
  register mhtyp *bufpoi;	/* Message Buffer			     */
  register partyp *parpoi;	/* Pointer auf aktuellen Parameter	     */

  bufpoi = putals("");				/* Kopfzeile		     */

  /* firstly, check for /parm value syntax, and if found handle it.
   * also, trash any remaining line after that before falling thru
   * into the old code
   */
  if( issyso() && *clipoi == '/' )
  {
  	nxtcli();
  	if( clicnt && ( parnum = nextnumber() -1 ) < tablesize 
  	    && skipspace() )
  	{
  		newval = nextnumber();
  		parpoi = &table[parnum];
  		if( newval >= parpoi->minimal && newval <= parpoi->maximal )
  			*(parpoi->paradr) = newval;
  	}
	clicnt = 0;
  }

  for (laenge = 0, parnum = 0, parpoi = table;
       parnum < tablesize;
       ++parnum, ++parpoi)			/* alle Parameter	     */
  {
    if (issyso())			/* Sysop am anderen Ende?    */
    {
      if (*clipoi != '*')			/* Wert aendern?	     */
      {
        newval = nextnumber();	/* neuen Wert holen	     */
        if ((newval >= parpoi->minimal) && (newval <= parpoi->maximal))
          *(parpoi->paradr) = newval;
        else 
          clicnt = 0;			/* Fehler: Rest vergessen    */
      }
      else					/* Parameter bleibt:	     */
        nxtcli();				/* das Sternchen verbrauchen */
     }
    if ((bufpoi->putcnt - laenge) > 72)
     {
      putchr('\15', bufpoi);			/* neue Zeile		     */
      laenge = bufpoi->putcnt;
     }
    else putchr(' ', bufpoi);

    putnum(*(parpoi->paradr), bufpoi);		/* Wert ausgeben	     */
   }
  seteom(bufpoi);		/* Endekennung anhaengen		     */
  }

#else

/* this is the original version of PARMS
 */
 
VOID	ccppar()		/* PARMS Befehl				     */
  {
  unsigned laenge;		/* Laenge der Zeile bisher		     */
  register unsigned newval;	/* neuer Wert des Parameters		     */
  unsigned parnum;		/* Nummer des aktuellen Parameters	     */
  register mhtyp *bufpoi;	/* Message Buffer			     */
  register partyp *parpoi;	/* Pointer auf aktuellen Parameter	     */

  bufpoi = putals("");				/* Kopfzeile		     */
  for (laenge = 0, parnum = 0, parpoi = partab;
       parnum < (sizeof(partab) / sizeof(struct param));
       ++parnum, ++parpoi)			/* alle Parameter	     */
   {
    if (issyso() == TRUE)			/* Sysop am anderen Ende?    */
     {
      if (*clipoi != '*')			/* Wert aendern?	     */
       {
        newval = nextnumber();	/* neuen Wert holen	     */
        if ((newval >= parpoi->minimal) && (newval <= parpoi->maximal))
         *(parpoi->paradr) = newval;
       
        else clicnt = 0;			/* Fehler: Rest vergessen    */
       }
      else					/* Parameter bleibt:	     */
        nxtcli();				/* das Sternchen verbrauchen */
     }
    if ((bufpoi->putcnt - laenge) > 72)
     {
      putchr('\15', bufpoi);			/* neue Zeile		     */
      laenge = bufpoi->putcnt;
     }
    else putchr(' ', bufpoi);

    putnum(*(parpoi->paradr), bufpoi);		/* Wert ausgeben	     */
   }
  seteom(bufpoi);		/* Endekennung anhaengen		     */
  }
#endif

/*---------------------------------------------------------------------------*/
VOID	ccprou()		/* ROUTES Befehl			     */
  {
  register unsigned mode;
  register mhtyp    *mbhd;
  register nbrtyp   *neigb;

  neigb = NULL;					/* default: kein Nachbar     */
  if (clicnt != 0)				/* aendern oder zeigen?	     */
   {
    if (getpar())				/* Nachbardaten holen	     */
     {
      neigb = (nbrtyp *) getnei(ndigi, ncall, nport);	/* existiert Nachbar?*/
      if (issyso())				/* nur SYSOP darf aendern    */
       {
        mode = *clipoi;				/* Modus holen, merken	     */
        nxtcli();
        if (getqua())				/* Qualitaet muss passen     */
         {
          if (mode == '+')			/* blockieren?		     */
           {
            if (!neigb)				/* Nachbar existiert nicht?  */
              neigb = (nbrtyp *) updnbr(ndigi, ncall, nport); /* erzeugen    */

            neigb->pathqu = nquali;		/* neue Daten setzen	     */
            neigb->locked = TRUE;		/* blockieren		     */
           }
          else
           {
            if (mode == '-')			/* freigeben?		     */
             {
              if (neigb != NULL)		/* nur wenn Nachbar existiert*/
               {
                neigb->pathqu = nquali;		/* neue Daten setzen	     */
                neigb->locked = FALSE;		/* nicht blockieren	     */
                if (neigb->nbrrou == 0)		/* wenn keine Wege aktiv     */
                 {
                  dealoc(unlink(neigb));	/* Eintrag loeschen	     */
                  neigb = NULL;
                 }
               }
             }
           }
         }
       }
     }
   }
  mbhd = putals("Routes:");			/* neue Daten zeigen	     */
  if (!neigb)					/* kein Nachbar angegeben    */
   {
    for (neigb = (nbrtyp *) neigbl.lnext;
        (nbrtyp *) &neigbl != neigb;
         neigb = (nbrtyp *) neigb->nbrlnk.lnext)
     {						/* alle Wege zeigen	     */
      putrou(neigb, mbhd);
     }
   }
  else
    putrou(neigb, mbhd);			/* sonst Wege des Nachbarn   */

  seteom(mbhd);					/* Ende Kennung anhaengen    */
  }

/*---------------------------------------------------------------------------*/
VOID	ccpres()		/* RESET Befehl				     */
 {
  if (userpo->sysflg == TRUE)	/* darf nur der Sysop	     */
   {
#ifdef MODIFIED			/* conditionally, only do a coldstart */
	if( clicnt /* > 0 */ )	/* if the reset command had a parameter */
#endif
    magicn = 0;			/* immer Kaltstart	     */
    reset();
   }
 }

#ifndef NOHILOW
/*---------------------------------------------------------------------------*/
VOID	ccplow()		/* LOW Befehl				     */
{
    LEDcontrol( FALSE );	/* common code removed to LEDcontrol()       */
}

/*---------------------------------------------------------------------------*/
VOID LEDcontrol( flag )
int flag;
{
    if (issyso() == TRUE)		/* darf nur der Sysop	     */
    {
        switch (nextnumber() )
        {
            case 0:
                CONled(flag);
                break;
            case 1:
                STAled(flag);
                break;
        }
    }
}

/*---------------------------------------------------------------------------*/
VOID	ccphig()		/* HIGH Befehl				     */
{
    LEDcontrol( TRUE );
}

#endif

/*---------------------------------------------------------------------------*/
VOID	ccpsys()		/* SYSOP Befehl				     */
  {
  register unsigned cnt;	/* Scratch Zaehler			     */
  register unsigned num;	/* Zufallszahl fuer Zeichenauswahl	     */
  register unsigned chk;	/* Check Zaehler			     */
  mhtyp	   *bufpoi;		/* Buffer fuer Passwort-Zahlen		     */

#ifdef MANAGED
  if( ( auditmask & 0x30 ) == 0x10 )
    notify(L7id, 6, this_station(), NULL, ccpcm6, 5 );
#endif
  if (paswle != 0)				/* ohne Passwort kein Sysop  */
   {
    bufpoi = putals("");			/* Buffer besorgen	     */
    for (cnt = 0; cnt < 5; ++cnt)		/* 5 Zahlen ausgeben	     */
     {
      do
       {
        do;
        while (((num = random()) >= paswle)	/* Zufallszahl holen	     */
          || (paswrd[num] == ' '));		/* gueltiges Zeichen?	     */
        for (chk = 0; chk < cnt; ++chk)		/* keine Zahl doppelt	     */
         {
          if ((userpo->paswrd[chk] & 0xff) == num) break;
         }
       }
      while (cnt != chk);
      userpo->paswrd[cnt] = num; /* neue Zahl merken			     */
      putchr(' ', bufpoi);
      putnum(num +1, bufpoi);	/* dem User mitteilen			     */
     }
    seteom(bufpoi);		/* Ende Kennung anhaengen		     */
    userpo->status = 3;		/* neuer Status: Passwort soll kommen	     */
   }
  }

/*---------------------------------------------------------------------------*/
VOID	ccpuse()		/* USERS Befehl				     */
  {
  register unsigned cnt;	/* Scratch Zaehler			     */
  register mhtyp *bufpoi;	/* MBHD fuer Meldungen			     */
  register usrtyp   *userp;	/* Userkontrollblock fuer CCP User	     */
  l2ltyp   *ucblk;		/* L2 User Kontrollblock		     */

  bufpoi = putals(version);			/* Kopf			     */
  putchr('(', bufpoi);
  putnum(nmbfre, bufpoi);			/* freie Buffer		     */
  putchr(')', bufpoi);

						/* erst die User mit Partner */
  for (cnt = 0, ptcrdp = ptcrdl;		/* Patchcord Liste absuchen  */
      cnt < ((NUMPAT +1) /2);
      ++cnt, ptcrdp += 2)			/* nur "linke" Eintraege     */
   {
    if (ptcrdp->luserl != NULL)				/* Eintrag belegt?   */
     {
      putchr('\015', bufpoi);
      bufpoi->l4time = bufpoi->putcnt;		/* Zeichen im Buffer merken  */
      putuse('L', ptcrdp->luserl, ptcrdp->lusert, bufpoi); /* linke Seite    */
      putspa(35, bufpoi);			/* Leerzeichen als Trennung  */
#ifdef CHOKE_FLAGS
      putstr( "  <", bufpoi );
      block_code( ptcrdp->luserl, ptcrdp->lusert, bufpoi);
      block_code( (ptcrdp+1)->luserl, (ptcrdp+1)->lusert, bufpoi);
      putstr( ">  ", bufpoi );
#else
      putstr("  <-->  ", bufpoi);		/* Verbindung steht	     */
#endif
      putuse('R', (ptcrdp +1)->luserl, (ptcrdp +1)->lusert, bufpoi);
						/* rechte Seite		     */
     }
   }
  for (userp = (usrtyp *) usccpl.lnext;		/* nun die User am CCP	     */
       (usrtyp *) &usccpl != userp;		/* bis zum Ende der Liste    */
       userp = userp->unext)
   {
    putchr('\15', bufpoi);			/* neue Zeile je User	     */
    bufpoi->l4time = bufpoi->putcnt;		/* Zeichen im Buffer merken  */
    putuse('L', userp->cblk_u, userp->typ_u, bufpoi); /* immer links	     */
    if (userp->status == 2)			/* Connect laeuft?	     */
     {
      putspa(35, bufpoi);			/* Trennung		     */
      putstr("  <..>  ", bufpoi);		/* Verbindung wartet	     */
      if ((userp->typ_p == 2)			/* wird L2 Verbindung?	     */
        &&((ucblk = userp->cblk_p)->state == 0)) /* Status: connect laeuft   */
       {
        putstr("CQ(", bufpoi);			/* Partner ist "CQ"	     */
        putid(ucblk->srcid, bufpoi);
        putchr(')', bufpoi);
       }
      else					/* andere L2 Verbindung	     */
        putuse('R', userp->cblk_p, userp->typ_p, bufpoi);
     }
#ifdef TALKCMD
     if( userp->status == 4 )			/* if user is in TALK mode   */
     {
     	putspa( 35, bufpoi );			/* then print appropriate    */
     	putstr("  <-->  Talk", bufpoi );		/* message showing it        */
     }
#endif
   }
  seteom(bufpoi);				/* Ende der Meldung setzen   */
  }
