// VNAccess.cpp : Defines the entry point for the DLL application.
//
// The documentation for these functions is to be found in VNAccess.h
// which with the addition of one extra error code is a copy of Greg's file

#include "stdafx.h"
#include "VNAccess.h"
#include "vnaio.h"
#include "MyVnaAccess.h"



// cheatblock is a speedup that does not honour the spec completely.
// Even if we are told to wait for a conversion to complete in
// getADCresult, we start the conversion then immediately say
// it is done even if it is not. This matches the way that
// exeter works. What it does is to repeat the loop:
//		set DDS (deferred update )
//		accessStatus
//		ddsFQUD (when it knows we have a result from above)
//		getADC result
//
// so we cheat in getADC result. We tell it we have completed
// when we have not and let it sort itself out in accessStatus()
// to remove the cheat (and slow it down) remove this definition....
#define CHEATBLOCK

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
    }
    return TRUE;
}

// this is a quick way to mask off an ADC value according to the number
// of bits requested, because we always read all 32 bits

unsigned int BitsMask[] =
{ 
	0, 0, 0, 0, 
	0, 0, 0xfc000000, 0xfe000000,
	0xff000000, 0xff800000, 0xffc00000, 0xffe00000,
	0xfff00000, 0xfff80000, 0xfffc0000, 0xfffe0000,
	0xffff0000, 0xffff8000, 0xffffc000, 0xffffe000,
	0xfffff000, 0xfffff800, 0xfffffc00, 0xfffffe00,
	0xffffff00, 0xffffff80, 0xffffffc0, 0xffffffe0,
	0xfffffff0, 0xfffffff8, 0xfffffffc, 0xfffffffe,
	0xffffffff
};

// *****************************************************************
// return DLL version number


VNACCESS_API int _stdcall VNAccessVersion ()
{
	return VNACCESS_VERSION;
}

// *****************************************************************
// although we have a tick count resolution variable in a VNAHelper
// object, it is not passed to the tick functions and we need it
// so we need this static.
// We *hope* its value is preserved.

int TickCountResolution = 0;

// *****************************************************************
// How accurate is the counter? We should have a fast counter,
// probably 3.579 MHz, but if not we will need to use GetTickCount()
// which is a 1 msec counter, so return 1000 in this case
// otherwise how many ticks per microseconds (probably 3) but just
// in case force to 1 if result is zero.

VNACCESS_API unsigned int _stdcall VNAccessGetusTickCountResolution ()
{
	// if we do not have a fast counter, return 1000 as we will
	// use GetTickCounter() which is a 1 msec counter
	// Otherwise we will return number of counts per microsecond
	LARGE_INTEGER lpPerformanceFreq;

	if( QueryPerformanceFrequency( &lpPerformanceFreq ) == 0 )
		TickCountResolution = 1000;
	else
	{
		TickCountResolution = lpPerformanceFreq.LowPart/1000000;
		if( TickCountResolution == 0 )
			TickCountResolution = 1;
	}
	return TickCountResolution;
}

// *****************************************************************
// Return a microsecond count. We need to convert count to microseconds
// to comply with Greg's specification
// Note we only return an int

VNACCESS_API unsigned int _stdcall VNAccessGetusTickCount ()
{
	LARGE_INTEGER lpPerformanceCount;

	// check to see if we know the frequency. If not go get it.

	if( TickCountResolution == 0 )
		TickCountResolution = VNAccessGetusTickCountResolution ();

	// if no fast counter use GetTickCount() otherwise
	// read fast counter and (approx) correct for clock speed
	if( QueryPerformanceCounter( &lpPerformanceCount ) == 0 )
		return GetTickCount() * 1000;
	else
		return lpPerformanceCount.LowPart / TickCountResolution;
}

// *****************************************************************
// Open VNA communications and check state of USB device
// creates a new helper object and returns its address as the handle
// Note we do a simple state check to see if the comms stack is working
// (just the comms stack - VNA may not be functional)
// may expand this to check VNA is powered up.....

VNACCESS_API VNAHANDLE _stdcall VNAccessOpen (LPCSTR pszPortToReserve, unsigned int IOAddress, unsigned int nOuts, unsigned int *pdwErrorCode)
{
	VNADeviceHelper* dVNA;				// Vector Network Analyzer hardware object

	dVNA = new VNADeviceHelper;
	if( dVNA->VNA->get_State() != 1 )
	{
		*pdwErrorCode = VNACCESS_COULDNOTWRITEREADPORT;
		return NULL;
	}
	else
	{
		*pdwErrorCode = 0;
		return (VNAHANDLE)dVNA;
	}
}

// *****************************************************************
// try to delete the VNA object

VNACCESS_API int _stdcall VNAccessClose (VNAHANDLE hVNA)
{
	VNADeviceHelper* dVNA;				// Vector Network Analyzer hardware object
	dVNA = (VNADeviceHelper *)hVNA;

	if( hVNA == NULL || hVNA == 0xffffffff || dVNA->HandleValid != HANDLEMARKER )
		return VNACCESS_INVALIDHANDLE;
	delete (VNADeviceHelper* )hVNA;
	return 0;
}

// *****************************************************************
// WARNING - the following functions are NOT supported.......

VNACCESS_API int _stdcall VNAccessModifyOutPort (VNAHANDLE hVNA, WORD wSetMask, WORD wClrMask, unsigned int dwFlags)
{
	return 0;
}


VNACCESS_API int _stdcall VNAccessReadStatusPort (VNAHANDLE hVNA)
{
	return 0;
}

VNACCESS_API int _stdcall VNAccessModifyCtrlPort (VNAHANDLE hVNA, WORD wSetMask, WORD wClrMask, unsigned int dwFlags)
{
	return 0;
}


VNACCESS_API int _stdcall VNAccessSetDDSControlSignalMapping (VNAHANDLE hVNA, VNACCESS_PinMapping_t m)
{
	return VNACCESS_SUCCESS;
}

VNACCESS_API int _stdcall VNAccessGetDDSControlSignalMapping (VNAHANDLE hVNA, VNACCESS_PinMapping_t m)
{
	return VNACCESS_SUCCESS;
}

VNACCESS_API int _stdcall VNAccessSetADCControlSignalMapping (VNAHANDLE hVNA, VNACCESS_PinMapping_t m)
{
	return VNACCESS_SUCCESS;
}

VNACCESS_API int _stdcall VNAccessGetADCControlSignalMapping (VNAHANDLE hVNA, VNACCESS_PinMapping_t m)
{
	return VNACCESS_SUCCESS;
}

VNACCESS_API int _stdcall VNAccessSetAttenControlSignalMapping (VNAHANDLE hVNA, VNACCESS_PinMapping_t m)
{
	return VNACCESS_SUCCESS;
}

VNACCESS_API int _stdcall VNAccessGetAttenControlSignalMapping (VNAHANDLE hVNA, VNACCESS_PinMapping_t m)
{
	return VNACCESS_SUCCESS;
}

VNACCESS_API int _stdcall VNAccessSetTestSetSwControlSignalMapping (VNAHANDLE hVNA, VNACCESS_PinMapping_t m)
{
	return VNACCESS_SUCCESS;
}

VNACCESS_API int _stdcall VNAccessGetTestSetSwControlSignalMapping (VNAHANDLE hVNA, VNACCESS_PinMapping_t m)
{
	return VNACCESS_SUCCESS;
}

// *****************************************************************
// We do not support other port mappings

VNACCESS_API int _stdcall VNAccessSetPredefinedControlSignalMapping (VNAHANDLE hVNA, int PLCSMIndex)
{
	if (PLCSMIndex == VNACCESS_PLCSM_0)
		return VNACCESS_SUCCESS;
	else
		return VNACCESS_ILLEGALMAP;
}

// *****************************************************************
// First main routine. What is the status (primarily of the ADC)
// If we have a cached result, we do not need to wait for the ADC so return SUCCESS
// Otherwise work out how long we may wait as specified by caller then start
// reading USB interface until either we timeout or it reports that an ADC
// conversion has finished.
// Note in timer calls we probably do not need to use 64 bit maths but the
// OS fast timer returns 64 bit counts and there is no presumption that it is clear
// on startup so to be on the safeside we use them.
// NOTE - ADC_TIMEOUT is not one of Greg's values but I needed it

VNACCESS_API int _stdcall VNAccessStatus (VNAHANDLE hVNA, unsigned int usBusyWaitForEOC, int ADCFlag)
{
	VNADeviceHelper* dVNA;				// Vector Network Analyzer hardware object
	dVNA = (VNADeviceHelper *)hVNA;
	VNA_RXBUFFER ReadBuffer;

	if( hVNA == 0 || hVNA == 0xffffffff || dVNA->HandleValid != HANDLEMARKER )
		return VNACCESS_INVALIDHANDLE;
	if( dVNA->CachedReading )
		return VNACCESS_SUCCESS;
	if( dVNA->VNA->get_State() != 1 )
		return VNACCESS_VNANOTRESPONDING;
	__int64 iStart = VNAccessGetusTickCount();
	__int64 iNow;
	__int64 iInterval = (usBusyWaitForEOC * dVNA->tick_speed) / 1000000;
	while( 1 )
	{
		if( dVNA->VNA->Read( &ReadBuffer ) )
		{
			if( ReadBuffer.return_status & bVnaStatusAdcDataReadyFlag )
			{
				dVNA->LastReading = ReadBuffer;
				dVNA->CachedReading = true;
				return VNACCESS_SUCCESS;
			}
			// this is a kludge - we do not know conversion is pending
			// so presume it is
			// otherwise why were we called?
			if( iInterval == 0 )
				return VNACCESS_CONVERSIONINPROGRESS;

			iNow = VNAccessGetusTickCount();
			if( (iNow - iStart ) > iInterval )
			{
				if( ReadBuffer.return_status & bVnaStatusAdcTimeoutFlag )
					return VNACCESS_ADCTIMEOUT;
				else
					return VNACCESS_VNANOTRESPONDING;
			}
		}
		else
			return VNACCESS_VNANOTRESPONDING;
	}
	// will never get here
	return VNACCESS_SUCCESS;
}

// *****************************************************************
// Not quite sure about this or its relevance so just claim we are quick :-)

VNACCESS_API unsigned int _stdcall VNAccessGetnsPerOut (VNAHANDLE hVNA)
{
	return 1;
}

// *****************************************************************
// Power down functions are NOT supported yet

VNACCESS_API unsigned int _stdcall VNAccessIdleDDSPowerDown (VNAHANDLE hVNA, unsigned int msIdleTime, void _stdcall CB(int, void *), void *ud)
{
	return 0;
}


VNACCESS_API int _stdcall VNAccessDDSPowerDown (VNAHANDLE hVNA)
{
	return 0;
}

// *****************************************************************
// Set the DDS frequency.
// Note that if the FQ_UD option to defer setting DDS is requested,
// we just store the whole message in the helper object and wait until
// FQ_UD requested (when we send the whole message)

VNACCESS_API int _stdcall VNAccessSetDDS (VNAHANDLE hVNA,
				 unsigned int dwRFTuningWord, unsigned int dwRFPhaseOffset, BOOL bRFPowerDown,
				 unsigned int dwLOTuningWord, unsigned int dwLOPhaseOffset, BOOL bLOPowerDown,
				 unsigned int *pusTickCount)
{
	VNADeviceHelper* dVNA;				// Vector Network Analyzer hardware object
	dVNA = (VNADeviceHelper *)hVNA;

	if( hVNA == 0 || hVNA == 0xffffffff || dVNA->HandleValid != HANDLEMARKER )
		return VNACCESS_INVALIDHANDLE;

	dVNA->TxDataStore.rf[0] = (dwRFPhaseOffset << 3) + (bRFPowerDown ? 4: 0 );
	dVNA->TxDataStore.rf[4] = dwRFTuningWord & 0xff;
	dVNA->TxDataStore.rf[3] = (dwRFTuningWord>>8) & 0xff;
	dVNA->TxDataStore.rf[2] = (dwRFTuningWord>>16) & 0xff;
	dVNA->TxDataStore.rf[1] = (dwRFTuningWord>>24) & 0xff;

	dVNA->TxDataStore.lo[0] = (dwLOPhaseOffset << 3) + (bLOPowerDown ? 4: 0 );
	dVNA->TxDataStore.lo[4] = dwLOTuningWord & 0xff;
	dVNA->TxDataStore.lo[3] = (dwLOTuningWord>>8) & 0xff;
	dVNA->TxDataStore.lo[2] = (dwLOTuningWord>>16) & 0xff;
	dVNA->TxDataStore.lo[1] = (dwLOTuningWord>>24) & 0xff;

	dVNA->TxDataStore.command_code = 0x55;
	dVNA->TxDataStore.flags = bCmdVnaSetDdsFlagsDdsSet + (dVNA->CfpMode ? 0: bCmdVnaSetDdsFlagsReset );
	dVNA->TxDataStore.adc_delay = 0;
	dVNA->TxDataStore.adc_reads = 0;
	dVNA->TxDataStore.adc_mode = 0;
	if( pusTickCount != VNACCESS_SETDDS_NO_FQ_UD )
	{
		if( !dVNA->VNA->Write( (union _VNA_TXBUFFER *)&(dVNA->TxDataStore), sizeof( VNA_TXBUFFER_CMD ) ))
			return VNACCESS_VNANOTRESPONDING;
		if( pusTickCount != NULL )
			*pusTickCount = VNAccessGetusTickCount();
	}
	return VNACCESS_SUCCESS;
}

// *****************************************************************
// In the lpt world, we would by now have written the DDS data but
// not have pulsed FQ_UD pin.
// In the USB world, we never sent the message - it is sitting in 
// the TX data store so we now simply send it

VNACCESS_API int _stdcall VNAccessDDSFQ_UD (VNAHANDLE hVNA, unsigned int *pusTickCount)
{
	VNADeviceHelper* dVNA;				// Vector Network Analyzer hardware object
	dVNA = (VNADeviceHelper *)hVNA;

	if( hVNA == 0 || hVNA == 0xffffffff || dVNA->HandleValid != HANDLEMARKER )
		return VNACCESS_INVALIDHANDLE;
	if( pusTickCount != VNACCESS_SETDDS_NO_FQ_UD )
	{
		dVNA->VNA->Write( (union _VNA_TXBUFFER *)&(dVNA->TxDataStore), sizeof( VNA_TXBUFFER_CMD ) );
		if( pusTickCount != NULL )
			*pusTickCount = VNAccessGetusTickCount();
//			dVNA->bSynchronised = true;
	}
	return VNACCESS_SUCCESS;
}


// *****************************************************************
// this is a cautious reset
// set DDS with reset and pause data out with power down bit set
// then remove the reset line and write again
// finally remove the power down bit and write again
// then do some reads to make sure all is well
// Might be an idea to clear cached readings as well - not sure

VNACCESS_API int _stdcall VNAccessResetDDS (VNAHANDLE hVNA)
{
	VNADeviceHelper* dVNA;				// Vector Network Analyzer hardware object
	dVNA = (VNADeviceHelper *)hVNA;
	VNA_RXBUFFER ReadBuffer;

	if( hVNA == 0 || hVNA == 0xffffffff || dVNA->HandleValid != HANDLEMARKER )
		return VNACCESS_INVALIDHANDLE;

	dVNA->TxDataStore.command_code = 0x55;
	dVNA->TxDataStore.flags = bCmdVnaSetDdsFlagsDdsSet + bCmdVnaSetDdsFlagsReset + bCmdVnaSetDdsFlagsPauseDataOut;
	dVNA->TxDataStore.adc_delay = 0;
	dVNA->TxDataStore.adc_reads = 0;
	dVNA->TxDataStore.adc_mode = 0;
	dVNA->TxDataStore.rf[0] = 4;
	dVNA->TxDataStore.rf[4] = 0;
	dVNA->TxDataStore.rf[3] = 0;
	dVNA->TxDataStore.rf[2] = 0;
	dVNA->TxDataStore.rf[1] = 0x01;

	dVNA->TxDataStore.lo[0] = 4;
	dVNA->TxDataStore.lo[4] = 0;
	dVNA->TxDataStore.lo[3] = 0;
	dVNA->TxDataStore.lo[2] = 0;
	dVNA->TxDataStore.lo[1] = 0x01;

	if( !dVNA->VNA->Write( (union _VNA_TXBUFFER *)&(dVNA->TxDataStore), sizeof( VNA_TXBUFFER_CMD ) ))
		return VNACCESS_VNANOTRESPONDING;

	dVNA->TxDataStore.flags = bCmdVnaSetDdsFlagsDdsSet + bCmdVnaSetDdsFlagsPauseDataOut;
	if( !dVNA->VNA->Write( (union _VNA_TXBUFFER *)&(dVNA->TxDataStore), sizeof( VNA_TXBUFFER_CMD ) ))
		return VNACCESS_VNANOTRESPONDING;

	dVNA->TxDataStore.rf[0] = 0;
	dVNA->TxDataStore.lo[0] = 0;
	dVNA->TxDataStore.flags = bCmdVnaSetDdsFlagsDdsSet;
	if( !dVNA->VNA->Write( (union _VNA_TXBUFFER *)&(dVNA->TxDataStore), sizeof( VNA_TXBUFFER_CMD ) ))
		return VNACCESS_VNANOTRESPONDING;

	dVNA->bSynchronised = true;

	for(int i=0;i<4;i++)
		if( !dVNA->VNA->Read( &ReadBuffer ) )
			return VNACCESS_VNANOTRESPONDING;

	return VNACCESS_SUCCESS;
}

// *****************************************************************
// Store frequency programming mode

VNACCESS_API int _stdcall VNAccessSetDDSCFP (VNAHANDLE hVNA, BOOL bCFP)
{
	VNADeviceHelper* dVNA;				// Vector Network Analyzer hardware object
	dVNA = (VNADeviceHelper *)hVNA;

	if( hVNA == 0 || hVNA == 0xffffffff || dVNA->HandleValid != HANDLEMARKER )
		return VNACCESS_INVALIDHANDLE;
	dVNA->CfpMode = bCFP ? true : false;
	return VNACCESS_SUCCESS;
}

// *****************************************************************
// return CFP mode

VNACCESS_API int _stdcall VNAccessGetDDSCFP (VNAHANDLE hVNA, BOOL *pbCFP)
{
	VNADeviceHelper* dVNA;				// Vector Network Analyzer hardware object
	dVNA = (VNADeviceHelper *)hVNA;

	if( hVNA == 0 || hVNA == 0xffffffff || dVNA->HandleValid != HANDLEMARKER )
		return VNACCESS_INVALIDHANDLE;
	*pbCFP = dVNA->CfpMode;
	return VNACCESS_SUCCESS;
}

// *****************************************************************
// do we think we are synched?

VNACCESS_API int _stdcall VNAccessGetDDSSync (VNAHANDLE hVNA, BOOL *pbSync)
{
	VNADeviceHelper* dVNA;				// Vector Network Analyzer hardware object
	dVNA = (VNADeviceHelper *)hVNA;

	if( hVNA == 0 || hVNA == 0xffffffff || dVNA->HandleValid != HANDLEMARKER )
		return VNACCESS_INVALIDHANDLE;
	*pbSync = dVNA->bSynchronised;
	return VNACCESS_SUCCESS;
}

// *****************************************************************
// store ADC speed. Do this for each ADC

VNACCESS_API int _stdcall VNAccessSetADCSpeed (VNAHANDLE hVNA, unsigned int dwADCSpeed, int ADCFlag)
{
	VNADeviceHelper* dVNA;				// Vector Network Analyzer hardware object
	dVNA = (VNADeviceHelper *)hVNA;

	if( hVNA == 0 || hVNA == 0xffffffff || dVNA->HandleValid != HANDLEMARKER )
		return VNACCESS_INVALIDHANDLE;

	if( ADCFlag == VNACCESS_ADC_DEFAULT || ADCFlag == VNACCESS_ADC_1 || ADCFlag == VNACCESS_ADC_BOTH )
		dVNA->ADCspeed[0] = dwADCSpeed;
	if( ADCFlag == VNACCESS_ADC_2 || ADCFlag == VNACCESS_ADC_BOTH )
		dVNA->ADCspeed[1] = dwADCSpeed;
	if( ADCFlag < VNACCESS_ADC_DEFAULT ||  ADCFlag > VNACCESS_ADC_BOTH )
		return VNACCESS_ILLEGALADCFLAG;

	return VNACCESS_SUCCESS;
}

// *****************************************************************
// Return current ADC speed

VNACCESS_API int _stdcall VNAccessGetADCSpeed (VNAHANDLE hVNA, unsigned int *pdwADCSpeed, int ADCFlag)
{
	VNADeviceHelper* dVNA;				// Vector Network Analyzer hardware object
	dVNA = (VNADeviceHelper *)hVNA;

	if( hVNA == 0 || hVNA == 0xffffffff || dVNA->HandleValid != HANDLEMARKER )
		return VNACCESS_INVALIDHANDLE;

	switch( ADCFlag )
	{
	case VNACCESS_ADC_DEFAULT:
	case VNACCESS_ADC_1:
	case VNACCESS_ADC_BOTH:
		*pdwADCSpeed = dVNA->ADCspeed[0];
		break;
	case VNACCESS_ADC_2:
		*pdwADCSpeed = dVNA->ADCspeed[1];
		break;
	default:
		return VNACCESS_ILLEGALADCFLAG;
	}
	return VNACCESS_SUCCESS;
}

// *****************************************************************
// OK, show time!
// Start an ADC conversion. If the delay is > 1000 usec we use millisecond mode
// otherwise parameter is units of 10usec APPROXIMATELY!!!!
// We always do just one ADC reading - we do not know what caller may want to do
// We use one or other ADC but not both as VNAccess can't currently cope
// We then clear any cached readings and then we have a choice.
// According to the interface spec we should wait until readidng is complete
// but that is a waste of time given the way Exeter seems to work.
// So we can cheat and tell it that we are ready (and hope to sort it out later)
// The code below implements both specs on conditional compilation

VNACCESS_API int _stdcall VNAccessStartADC (VNAHANDLE hVNA, unsigned int usTickCount, unsigned int usSetupMin, unsigned int usBusyWaitForEOC, unsigned int *pusTickCount, int ADCFlag)
{
	VNADeviceHelper* dVNA;				// Vector Network Analyzer hardware object
	dVNA = (VNADeviceHelper *)hVNA;
	VNA_TXBUFFER_CMD TxData;

	if( hVNA == 0 || hVNA == 0xffffffff || dVNA->HandleValid != HANDLEMARKER )
		return VNACCESS_INVALIDHANDLE;

	TxData.command_code = 0x55;
	TxData.flags = (usSetupMin > 1000 ? 0 : bCmdVnaSetDdsFlagsDelayIsUsec);
	TxData.adc_delay = usSetupMin > 1000 ? usSetupMin / 1000 : usSetupMin/10;
	TxData.adc_reads = 1;
	TxData.adc_mode = (dVNA->ADCspeed[ADCFlag==VNACCESS_ADC_2 ? 1:0] & 0x1f);
	switch( ADCFlag )
	{
	case VNACCESS_ADC_DEFAULT:
	case VNACCESS_ADC_1:
		break;
	case VNACCESS_ADC_2:
		TxData.adc_mode |= CmdVnaSetDdsAdcModeDet2;
		break;
	case VNACCESS_ADC_BOTH:
		TxData.adc_mode |= CmdVnaSetDdsAdcModeSimultaneous;
		break;
	default:
		return VNACCESS_ILLEGALADCFLAG;
	}


	if( !dVNA->VNA->Write( (union _VNA_TXBUFFER *)&(TxData), sizeof( VNA_TXBUFFER_CMD ) ))
		return VNACCESS_VNANOTRESPONDING;

	dVNA->CachedReading = false;

	if( pusTickCount != NULL )
		*pusTickCount = VNAccessGetusTickCount();

// cheat block. According to spec should not do this
// but (if used with block below) it runs much faster
#ifdef CHEATBLOCK
	return VNACCESS_SUCCESS;
// end of cheat
#else
	__int64 iStart = usTickCount;
	__int64 iNow;
	__int64 iInterval = (usBusyWaitForEOC * dVNA->tick_speed) / 1000000;
	VNA_RXBUFFER ReadBuffer;

	while( 1 )
	{
		if( dVNA->VNA->Read( &ReadBuffer ) )
		{
			if( ReadBuffer.return_status & bVnaStatusAdcDataReadyFlag )
			{
				dVNA->LastReading = ReadBuffer;
				dVNA->CachedReading = true;
				return VNACCESS_SUCCESS;
			}
			iNow = VNAccessGetusTickCount();
			if( (iNow - iStart ) > iInterval )
			{
				 if ( ReadBuffer.return_status & bVnaStatusAdcTimeoutFlag )
					return VNACCESS_ADCTIMEOUT;
				 else
					return VNACCESS_VNANOTRESPONDING;
			}
		}
		else
			return VNACCESS_VNANOTRESPONDING;
	}
	
	return VNACCESS_SUCCESS;
#endif

}

// *****************************************************************
// Now get the result (as the caller thinks one is ready)
// Note that to be on the safe side (if we are cheating) we may
// need to wait until it really IS ready but normally a call
// to VNAccessStatus() will have sorted this out. If this is so,
// then there will be a cached reading so we skip over this logic anyway
// Note also that we always read the full 32 bits so in order to comply
// with the interface spec we mask off low order bits if asked to.

VNACCESS_API int _stdcall VNAccessGetADCResult (VNAHANDLE hVNA,
				       unsigned int usBusyWaitForEOC, unsigned int *pdwADCResult,
				       unsigned int dwMinADCResultBits, unsigned int *pdwActualADCResultBits,
				       unsigned int usTickCount, unsigned int usSetupMin,
				       unsigned int *pusTickCount,
				       int ADCFlag, unsigned int *pdwADCResult2)
{
	VNADeviceHelper* dVNA;				// Vector Network Analyzer hardware object
	dVNA = (VNADeviceHelper *)hVNA;
	VNA_RXBUFFER ReadBuffer;
	int bits;


	if( hVNA == 0 || hVNA == 0xffffffff || dVNA->HandleValid != HANDLEMARKER )
		return VNACCESS_INVALIDHANDLE;
	if( !dVNA->CachedReading )
	{
		if( dVNA->VNA->get_State() != 1 )
			return VNACCESS_VNANOTRESPONDING;
// By a strict reading of the specification I think this code should be here
// but this makes it slow. Instead second block below is used as a cheat
#ifndef CHEATBLOCK
		if( !dVNA->VNA->Read( &ReadBuffer ) )
			return VNACCESS_VNANOTRESPONDING;
		dVNA->LastReading = ReadBuffer;
		if( ReadBuffer.return_status & bVnaStatusAdcTimeoutFlag )
			return VNACCESS_ADCTIMEOUT;
		if( ReadBuffer.return_status & bVnaStatusAdcDataReadyFlag )
			dVNA->LastReading = ReadBuffer;
		else 
			return VNACCESS_CONVERSIONINPROGRESS;

// start of cheat block (also see early return in startADC function.....
#else
		if( pusTickCount != NULL )
			*pusTickCount = VNAccessGetusTickCount();

		__int64 iStart = VNAccessGetusTickCount(); // usTickCount;
		__int64 iNow;
		__int64 iInterval = (usBusyWaitForEOC * dVNA->tick_speed) / 1000000;

		while( 1 )
		{
			if( dVNA->VNA->Read( &ReadBuffer ) )
			{
				if( ReadBuffer.return_status & bVnaStatusAdcDataReadyFlag )
				{
					dVNA->LastReading = ReadBuffer;
					dVNA->CachedReading = true;
					break;
				}
				iNow = VNAccessGetusTickCount();
				if( (iNow - iStart ) > iInterval )
				{
					 if ( ReadBuffer.return_status & bVnaStatusAdcTimeoutFlag )
						return VNACCESS_ADCTIMEOUT;
					 else
						return VNACCESS_VNANOTRESPONDING;
				}
			}	
			else
				return VNACCESS_VNANOTRESPONDING;
		}
#endif
// end of cheat block
		
	}

	bits = dwMinADCResultBits;
	if( bits < 6 ) bits = 6;
	else if( bits > 32 ) bits = 32;
	*pdwADCResult = (dVNA->LastReading.data[0]<<24)|(dVNA->LastReading.data[1]<<16)|
					(dVNA->LastReading.data[2]<<8)|(dVNA->LastReading.data[3]);
	*pdwADCResult &= BitsMask[bits];

	if( ADCFlag == VNACCESS_ADC_BOTH )
	{
		if( dVNA->LastReading.ADC_reads_done > 1 )
		{
			*pdwADCResult2 = (dVNA->LastReading.data[4]<<24)|(dVNA->LastReading.data[5]<<16)|
							(dVNA->LastReading.data[6]<<8)|(dVNA->LastReading.data[7]);
			*pdwADCResult2 &= BitsMask[bits];
		}
		else
			return VNACCESS_ILLEGALADCFLAG;
	}

	if ( pdwActualADCResultBits != 0 )
		*pdwActualADCResultBits = bits;
	dVNA->CachedReading = false;
	if( pusTickCount != VNACCESS_NO_START )
	{
		VNAccessStartADC (hVNA, *pusTickCount, usSetupMin,usBusyWaitForEOC, pusTickCount,ADCFlag);
		if( pusTickCount != NULL )
			*pusTickCount = VNAccessGetusTickCount();
	}
	return VNACCESS_SUCCESS;
}

// *****************************************************************
// We work differently to the lpt port. There, the code leaves the ADC
// held on its last bit waiting to start. We do not, we just tell it
// to read.

VNACCESS_API int _stdcall VNAccessRaiseADCnCS (VNAHANDLE hVNA, unsigned int usTickCount, unsigned int usSetupMin, unsigned int *pusTickCount, int ADCFlag)
{
	VNADeviceHelper* dVNA;				// Vector Network Analyzer hardware object
	dVNA = (VNADeviceHelper *)hVNA;
	VNA_TXBUFFER_CMD TxData;

	if( hVNA == 0 || hVNA == 0xffffffff || dVNA->HandleValid != HANDLEMARKER )
		return VNACCESS_INVALIDHANDLE;

	TxData.command_code = 0x55;
	TxData.flags = (usSetupMin > 1000 ? 0 : bCmdVnaSetDdsFlagsDelayIsUsec);
	TxData.adc_delay = usSetupMin > 1000 ? usSetupMin / 1000 : usSetupMin/10;
	TxData.adc_reads = 1;
	TxData.adc_mode = (dVNA->ADCspeed[ADCFlag==VNACCESS_ADC_2 ? 1:0] & 0x1f);
	switch( ADCFlag )
	{
	case VNACCESS_ADC_DEFAULT:
	case VNACCESS_ADC_1:
		break;
	case VNACCESS_ADC_2:
		TxData.adc_mode |= CmdVnaSetDdsAdcModeDet2;
		break;
	case VNACCESS_ADC_BOTH:
		TxData.adc_mode |= CmdVnaSetDdsAdcModeSimultaneous;
		break;
	default:
		return VNACCESS_ILLEGALADCFLAG;
	}

	if( pusTickCount != NULL )
		*pusTickCount = VNAccessGetusTickCount();

	if( dVNA->VNA->Write( (union _VNA_TXBUFFER *)&(TxData), sizeof( VNA_TXBUFFER_CMD ) ))
		return VNACCESS_SUCCESS;
	else
		return VNACCESS_VNANOTRESPONDING;

}

// *****************************************************************
// Set attenuator - simple function

VNACCESS_API int _stdcall VNAccessSetAtten (VNAHANDLE hVNA, int Atten)
{
	VNADeviceHelper* dVNA;				// Vector Network Analyzer hardware object
	dVNA = (VNADeviceHelper *)hVNA;
	VNA_TXBUFFER_RAW WriteData;


	if( hVNA == 0 || hVNA == 0xffffffff || dVNA->HandleValid != HANDLEMARKER )
		return VNACCESS_INVALIDHANDLE;


	WriteData.command_code = 0x5A;
	WriteData.flags = CmdVnaRawDataFlagsSetAtt;
	WriteData.atten = Atten & 7;
	if( dVNA->VNA->Write( (union _VNA_TXBUFFER *)&(WriteData), sizeof( VNA_TXBUFFER_RAW ) ))
		return VNACCESS_SUCCESS;
	else
		return VNACCESS_VNANOTRESPONDING;
}

// *****************************************************************
// MISSING FUNCTION - no switching yet

VNACCESS_API int _stdcall VNAccessSetTestSetSw (VNAHANDLE hVNA, int TestSetSw)
{
	return VNACCESS_SUCCESS;
}

// *****************************************************************
// As defined in interface spec, return a tuning word given a frequency pair

VNACCESS_API unsigned int _stdcall VNAccessFreqToTW (unsigned int RefClk, unsigned int F0)
{
	__int64 x = ((__int64)F0 << 32) / RefClk;
	return (int)x;
}

// *****************************************************************
// Converse of above - given a tuning word what frequency?

VNACCESS_API unsigned int _stdcall VNAccessTWToFreq (unsigned int RefClk, unsigned int TW)
{
	__int64 x = (__int64)RefClk * (__int64)TW;
	return (int)(x >> 32);
}

// *****************************************************************
// For a given ADC reading, what is the approx reading in uvolts?
// see Greg's documentation and the header file

VNACCESS_API int _stdcall VNAccessADCResultTouVolts (unsigned int ADCResult, unsigned int ADCResultBits, int *pOverUnder)
{
	signed __int64 x;


	x = VNAccessADCResultToCounts( ADCResult, ADCResultBits, pOverUnder);

	if( *pOverUnder == 0 )
		x = (x * (-2500000))>>24;
	return (int)x;
}

// *****************************************************************
// Work out counts from result, checking for overflow.
// I have no idea why we need the number of bits - 
// we don't use it anyway unless I missed something!

VNACCESS_API int _stdcall VNAccessADCResultToCounts (unsigned int ADCResult, unsigned int ADCResultBits, int *pOverUnder)
{
	int x = 0;
	if( (ADCResult & 0x30000000) == 0 )
		*pOverUnder = -1;
	else if ( (ADCResult & 0x30000000) == 0x30000000 )
		*pOverUnder = 1;
	else
	{
		*pOverUnder = 0;
		x = (ADCResult>>5) & 0x00ffffff;
		if( (ADCResult & 0x20000000 ) == 0)
			x |= 0xff000000;
	}
	return x;
}

// *****************************************************************
// MISSING FUNCTION - not sure what it does in detail !
// This may be a serious omission but I don't understand the function well
// enough to code it yet

VNACCESS_API void _stdcall VNAccessRFVectorFromDetectorMeasurements (int dwVDC0, int dwVOFF0, int dwVDC90, int dwVOFF90, double *pRe, double *pIm)
{

}







