// MyVNAccess.cpp : Manages the helper object creation / deletion
//

#include "stdafx.h"
#include "VNAccess.h"
#include "vnaio.h"
#include "MyVnaAccess.h"

// *****************************************************************
// When a helper object is created, initialise its values.
// We need a VNADevice object for a start
// Note that we need to know counter resolution for timings
// and there is no point calling it every time

__declspec(dllexport) _stdcall VNADeviceHelper::VNADeviceHelper()							// Construct the VNADevice
{
	VNA = new VNADevice;					// Allocate a Helper to the VNADevice
	HandleValid = HANDLEMARKER;
	CachedReading = false;
	bSynchronised = false;
	ADCspeed[0] = ADCspeed[1] = 0;
	CfpMode = true;
	LARGE_INTEGER lpPerformanceFreq;
	if( QueryPerformanceFrequency( &lpPerformanceFreq ) == 0 )
		tick_speed = 1000;
	else
		tick_speed = lpPerformanceFreq.QuadPart;
};

__declspec(dllexport) _stdcall VNADeviceHelper::~VNADeviceHelper()
{
	HandleValid = 0;
	delete VNA;						// since d is on the unmanaged heap
}
