#ifndef _MyVnaAccessHeader_
#define _MyVnaAccessHeader_

// this class is used to hold vna device management data
// When a vna device is opened, a Helper object is created
// and initialised. It holds the data needed by the dll
// to access the VNA via the USB port, and is used by being
// passed as a handle between calls. Therefore this handle
// is returned from the open call and the dll functions
// expect a pointer to such an object to be passed as to 
// them as a handle. To try to protect against being given
// garbage, the first entry is a fixed value that we expect
// to find or we return an error.

class VNADeviceHelper
{
private:


public:
	__declspec(dllexport) _stdcall VNADeviceHelper();			// Constructor: open device, set state
	__declspec(dllexport) _stdcall ~VNADeviceHelper();		// Destructor: release __nogc objects and structs

	int HandleValid;				// fixed expected value
	class VNADevice * VNA;			// holds the USB device state
	bool CachedReading;				// if true, there is an unused reading in LastReading
	VNA_RXBUFFER LastReading;		// a copy of the last data read from the interface
	bool CfpMode;					// continuous freq programming mode - see greg's documentation
	VNA_TXBUFFER_CMD TxDataStore;	// current tx data that (may be) waiting to be sent
	bool bSynchronised;				// flag true if we think we are synchronised
	int ADCspeed[2];				// speed flag for each ADC but we only use one!
	__int64 tick_speed;				// used to calculate microseconds

};

// if HandleValid does not contain this in any handle we are passed then return an error
#define HANDLEMARKER 0x5A6B

#endif // _MyVnaAccessHeader_
