//(C) Copyright Dave Roberts G8KBB 2005
// This program is released only for the purpose of self training and eduation
// in amatuer radio. It may not be used for any commercial purpose, sold or
// modified.
// It has been written as an exercise in self tuition by me as part of my hobby
// and I make no claims about its fitness for purpose or correct operation.

#include "stdafx.h"
#include "usb configure.h"

#include "common.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

int b_9912;
CCyUSBDevice *USBDevice = NULL;
bool bUsingCyUSB = false;
int nCyUsbDevices = 0;
int nN2pkUsbDevices = 0;
int nMsaUsbDevices = 0;
int nCyUsbDevice = 0;
CCyUSBDevice *USBDeviceN2PK = NULL;
CCyUSBDevice *USBDeviceCyUSB = NULL;
CCyUSBDevice *USBDeviceMSA = NULL;
bool bUsingN2pkGUID = false;
bool bSupport9912 = false;
bool bUsingMsaGUID = false;
// interface type;
int nInterfaceType = INTERFACE_N2PK;

/////////////////////////////////////////////////////////////////////////////
// Taken from the Ezmr application. Define structures for image of
// memory of FX2 for download


TMemCache m_MemCache;	//target mem cache info
TMemImg m_MemImg;		//target memory image

/////////////////////////////////////////////////////////////////////////////
// Open driver to FX2 chip. Return handle to device and flag for success


bool bOpenDriver (HANDLE * phDeviceHandle, PCHAR devname)
{
    char completeDeviceName[64];

    strcpy_s (completeDeviceName, sizeof(completeDeviceName ), "\\\\.\\" );
    strcat_s (completeDeviceName, sizeof(completeDeviceName ), devname );

    *phDeviceHandle = CreateFile(   completeDeviceName,
		                            GENERIC_WRITE,
		                            FILE_SHARE_WRITE,
		                            NULL,
		                            OPEN_EXISTING,
		                            0,
		                            NULL);

    return (*phDeviceHandle != INVALID_HANDLE_VALUE); 
}

/////////////////////////////////////////////////////////////////////////////
// Shared routine for download and program.
// Given a filename, try to open it and download to FX2 chip, giving results
// in window and a success / failure flag as an int

int DownloadFile( CEdit *pWnd, CString m_LogFilename )
{
//	CException ex;
	FILE *fp;
	CString sStatus, sTemp;
    HANDLE  hDevice = NULL;
	BOOL bResult;
	ANCHOR_DOWNLOAD_CONTROL downloadControl;
	unsigned long nBytes;

	char endianConversion = 0;    // Mask for endian conversion
	DWORD offset = 0;         		// Offset -- set to -1 to get offset from srec or hex file

	int nOffset = 0;
	int nByteCount = 0;

	m_MemCache.pImg = &m_MemImg;

	errno = fopen_s( &fp, m_LogFilename, "rb");
	if( errno )
	{
		AfxMessageBox( IDS_INVALID_FILENAME, MB_OK );
		return 0;
	}
	int result = intel_in(fp, &m_MemCache, offset, endianConversion, FALSE);
	nByteCount = m_MemCache.nTotalBytes;
	if( nByteCount == 0 || ferror( fp ) != 0 )
	{
		AfxMessageBox( IDS_FILE_READ_ERROR, MB_OK );
		fclose(fp);
		return 0;
	}
	fclose(fp);

	pWnd->FmtLines( true );
	sStatus.Format("Read file %s\r\nByte Count = 0x%04x bytes", m_LogFilename, nByteCount );
	pWnd->SetWindowText(sStatus);

	sStatus += "\r\nDriver name: ";
	sStatus += pcDriverName;
	pWnd->SetWindowText(sStatus);

	for(int k=0; k<m_MemCache.nSeg; k++)
	{ //check for high mem data
		if(m_MemCache.pSeg[k].TAddr >= 0x4000)
		{
			sStatus += "\r\nThis version does not support vendor download of data to addresses >= 0x4000";
			pWnd->SetWindowText(sStatus);
			hDevice = NULL;
			return 0;  
		}
	}

	bool bOpenedOK = false;
	CCyControlEndPoint *ept;
	if( bUsingCyUSB )
	{
		bOpenedOK = USBDevice->Open( nCyUsbDevice );
		ept = USBDevice->ControlEndPt;
	}
	else
		bOpenedOK = bOpenDriver (&hDevice, (LPTSTR)(LPCTSTR)pcDriverName);
	if( !bOpenedOK )
	{
		sTemp.LoadString( IDS_OPEN_DRIVER_FAIL );
		sStatus += "\r\n";
		sStatus += sTemp;
		pWnd->SetWindowText(sStatus);
		hDevice = NULL;
		return 0;
	}

	Reset8051( true, hDevice );

	for(int j=0; j<m_MemCache.nSeg; j++)
	{
		if(m_MemCache.pSeg[j].TAddr < 0x4000)
		{
			long len;
			downloadControl.Offset = (WORD)m_MemCache.pSeg[j].TAddr;
			if( bUsingCyUSB )
			{
				ept->Target = TGT_DEVICE;
				ept->ReqType = REQ_VENDOR;
				ept->Direction = DIR_TO_DEVICE;
				ept->ReqCode = 0xa0;
				ept->Value = (WORD)m_MemCache.pSeg[j].TAddr;
				ept->Index = 0;
				len = m_MemCache.pSeg[j].Size;
				bResult = ept->Write((PUCHAR)m_MemCache.pSeg[j].pData, len );
			}
			else
			{
				bResult = DeviceIoControl (hDevice,
					IOCTL_EZUSB_ANCHOR_DOWNLOAD,
					&downloadControl,
					sizeof(ANCHOR_DOWNLOAD_CONTROL),
					m_MemCache.pSeg[j].pData,
					m_MemCache.pSeg[j].Size,
					(unsigned long *)&nBytes,
					NULL);
			}
		}
	}
	Reset8051( false, hDevice );

	if (bResult==TRUE)
			sTemp.LoadString( IDS_DOWNLOAD_SUCCESS );
	else
			sTemp.LoadString( IDS_DOWNLOAD_FAIL );
	sStatus += "\r\n";
	sStatus += sTemp;
	pWnd->SetWindowText(sStatus);

	CloseHandle (hDevice);

	return bResult;
}

#define MAXSTR 256 // Maximum length of Intel Hex file string

/////////////////////////////////////////////////////////////////////////////
// Taken from Cypress ezmr program.
// Application reads in an Intel hex file and converts to binary
// putting image into structure

// Return code 0 for success or not zero for error.
// In event of error, code is string index

int intel_in(FILE *fpIn, TMemCache* pMemCache, DWORD &ioOffset, 
						char endianFlags, BOOLEAN spaces)
{
	int i;
	char str[MAXSTR];
	unsigned byte;
	
	int curSeg = 0;			// current seg record 
	int recType;
	unsigned addr;
	int cnt;
	unsigned int totalRead = 0;
	int CNTFIELD ;
	int ADDRFIELD;
	int RECFIELD ;
	int DATAFIELD;
	
	// offsets of fields within record -- may change later due to "spaces" setting
	CNTFIELD    = 1;
	ADDRFIELD   = 3;
	RECFIELD    = 7;
	DATAFIELD   = 9;

	if (!fpIn)
		return(IDS_INVALID_FILE_POINTER);
	
	addr = 0;
	
	pMemCache->nSeg = 0;
	while(fgets(str,MAXSTR,fpIn))
	{
		TRACE("dldhex:%s", str);
		if(str[0]!=':')
		{
			return(IDS_FILE_LINE_STARTS_NOT_COLON);
		}
		
		/* get the record type */
		if (spaces || str[1] == ' ')
		{
			CNTFIELD    = 1 + 1;
			ADDRFIELD   = 3 + 2;
			RECFIELD    = 7 + 3;
			DATAFIELD   = 9 + 4;
		}
		
		sscanf_s(str+RECFIELD,"%2x",&recType);
		
		PCHAR ptr = (PCHAR)pMemCache->pImg;
		switch(recType)
		{
		case 2: /*seg record*/
			sscanf_s(str+DATAFIELD,"%4x",&curSeg);
			curSeg *= 0x10;
			break;
			
		case 0: /*data record*/
			sscanf_s(str+CNTFIELD,"%2x",&cnt);
			sscanf_s(str+ADDRFIELD,"%4x",&addr);
			if(addr >= TGT_IMG_SIZE)
				return(IDS_FILE_ADDRESSS_RANGE_ERROR);
			ptr += addr; // get pointer to location in image
			
			if(pMemCache->nSeg && 
				(pMemCache->pSeg[pMemCache->nSeg-1].TAddr == 
				addr - pMemCache->pSeg[pMemCache->nSeg-1].Size) &&
				(pMemCache->pSeg[pMemCache->nSeg-1].Size + cnt <= MAX_EP0_XFER_SIZE) )
			{ // if the segment is contiguous to the last segment, and it's not too big yet
				pMemCache->pSeg[pMemCache->nSeg-1].Size += cnt; // append to previous segment
			}
			else
			{ // start a new segment
				pMemCache->pSeg[pMemCache->nSeg].TAddr = addr;
				pMemCache->pSeg[pMemCache->nSeg].Size = cnt;
				pMemCache->pSeg[pMemCache->nSeg].pData = ptr;
				pMemCache->nSeg++;
			}
			
			
			for(i=0; i<cnt; i++)
			{
				sscanf_s(str+DATAFIELD+i*2,"%2x",&byte);
				*(ptr + i) = byte;
				totalRead++;
			}
			break;
			
		case 1: /*end record*/
			pMemCache->nTotalBytes = totalRead;
			return 0;
			break;
			
		default:
			break;
		}
	}
	return(IDS_FILE_NO_EOF);		// missing end record
}

/////////////////////////////////////////////////////////////////////////////
// Reset 8051, putting it into hold or run mode (bHold flag)

int Reset8051( bool bHold, HANDLE hDevice )
{
	VENDOR_REQUEST_IN	myRequest;
	BOOL bResult;
	unsigned long nBytes;
	LONG len;
				
	if( bUsingCyUSB )
	{
		CCyControlEndPoint *ept;
		ept = USBDevice->ControlEndPt;
		ept->Target = TGT_DEVICE;
		ept->ReqType = REQ_VENDOR;
		ept->Direction = DIR_TO_DEVICE;
		ept->ReqCode = 0xA0;
		ept->Value = 0xE600;
		ept->Index = 0;
		unsigned char data = bHold == true ? 1 : 0;
		len = 1;
		bResult = ept->Write( &data, len ); // >XferData(&data, len);
	}
	else
	{
		myRequest.bRequest = 0xA0;
		myRequest.wValue = 0xE600; // using CPUCS.0 in FX2
		myRequest.wIndex = 0x00;
		myRequest.wLength = 0x01;
		myRequest.bData = bHold == true ? 1 : 0;
		myRequest.direction = 0x00;
			
		if (hDevice != NULL) 
		{// Perform the Get-Descriptor IOCTL
			bResult = DeviceIoControl (hDevice,
				IOCTL_Ezusb_VENDOR_REQUEST,
				&myRequest,
				sizeof(VENDOR_REQUEST_IN),
				NULL,
				0,
				(unsigned long *)&nBytes,
				NULL);
						
		}/* if valid driver handle */
	}
	return( bResult );
}

/////////////////////////////////////////////////////////////////////////////
// Given a buffer and data size, convert to HEX and place result in sData
// with line breaks at appropriate intervals
			
int DumpBuffer(char *buffer,int nBytes,CString *sData)
{
	int i;
	CString sTemp;

	for(i=0; i<nBytes; i++)
	{
		sTemp.Format( "%02X ", (unsigned)(buffer[i]&0xff));
		*sData += sTemp;
		if( ( i & 0xf ) == 0xf )
			*sData += "\r\n";
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// Used twice by communicate, this routine gets a string desciptor as defined by
// input parameter, placing response in sOutput.

bool GetStringDescriptor( HANDLE hDevice, GET_STRING_DESCRIPTOR_IN *input, CString *sOutput )
{
	bool bResult;
	Usb_String_Descriptor *pUsb_String_Desc;
	wchar_t szTempBuf[256];
	unsigned long nBytes, ulLength;
	CString sTemp;

	if( bUsingCyUSB )
	{
		CCyControlEndPoint *ept;
		USB_STRING_DESCRIPTOR str;
		ept = USBDevice->ControlEndPt;
		ept->Target = TGT_DEVICE;
		ept->ReqType = REQ_STD;
		ept->Direction = DIR_FROM_DEVICE;
		ept->ReqCode = 0x6;
		ept->Value = 0x0300 + (input->Index & 0xff );
		ept->Index = input->LanguageId;
		long len = sizeof(USB_STRING_DESCRIPTOR);
		bResult = ept->Read( (PUCHAR)&str, len ); // >XferData(&data, len);
		if( bResult )
		{
			len = str.bLength;
			bResult = ept->Read( (PUCHAR)&szTempBuf, len ); // >XferData(&data, len);
		}
	}
	else
	{
		// Get the first bytes of the descriptor to determine the size of
		// the entire descriptor.
		// Perform the Get-Descriptor IOCTL
		bResult = (0 != DeviceIoControl (hDevice,
				IOCTL_Ezusb_GET_STRING_DESCRIPTOR,
				input,
				sizeof (GET_STRING_DESCRIPTOR_IN),
				szTempBuf,
				sizeof (Usb_String_Descriptor),
				(unsigned long *)&nBytes,
				NULL));
				

		// Now get the entire descriptor
		// Perform the Get-Descriptor IOCTL
		if( bResult)
		{
			ulLength = GET_STRING_DESCRIPTOR_LENGTH(szTempBuf);
			ASSERT(ulLength >= 0);

			bResult = ( 0 != DeviceIoControl (hDevice,
				IOCTL_Ezusb_GET_STRING_DESCRIPTOR,
				input,
				ulLength,
				szTempBuf,
				ulLength,
				(unsigned long *)&nBytes,
				NULL));
		}
	}
	if (bResult) 
	{
		sOutput->LoadString( IDS_GET_STRING_SUCCESS );
		sTemp.Format("index=%d :",input->Index);
		*sOutput +=sTemp;
		pUsb_String_Desc = (Usb_String_Descriptor *)szTempBuf;
		for(int i=0; i<pUsb_String_Desc->bLength/2-1;i++)
			*sOutput += (char)pUsb_String_Desc->bString[i];
		*sOutput += "\r\n";
	} 
	else 
	{
		sOutput->LoadString( IDS_GET_STRING_FAIL );
	} 
	return bResult;
}


