// Setup.cpp : implementation file
//
//(C) Copyright Dave Roberts G8KBB 2005
// This program is released only for the purpose of self training and eduation
// in amatuer radio. It may not be used for any commercial purpose, sold or
// modified.
// It has been written as an exercise in self tuition by me as part of my hobby
// and I make no claims about its fitness for purpose or correct operation.


#include "stdafx.h"
#include "usb configure.h"
#include "Setup.h"
#include "FindDevices.h"
#include "common.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern int b_9912;
/////////////////////////////////////////////////////////////////////////////
// Setup property page

IMPLEMENT_DYNCREATE(Setup, CPropertyPage)

Setup::Setup() : CPropertyPage(Setup::IDD)
{
	//{{AFX_DATA_INIT(Setup)
	//}}AFX_DATA_INIT
	USBDeviceCyUSB = new CCyUSBDevice(NULL, CYUSBDRV_GUID);
	USBDeviceN2PK = new CCyUSBDevice(NULL, N2PK_USB_GUID);
	USBDeviceMSA = new CCyUSBDevice(NULL, MSA_USB_GUID);

	bUsingCyUSB = false;
}

Setup::~Setup()
{
	delete USBDeviceCyUSB;
	USBDeviceCyUSB = NULL;
	delete USBDeviceN2PK;
	USBDeviceN2PK = NULL;
	delete USBDeviceMSA;
	USBDeviceMSA = NULL;
}

void Setup::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(Setup)
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(Setup, CPropertyPage)
	//{{AFX_MSG_MAP(Setup)
	ON_EN_KILLFOCUS(IDC_EDIT_DRIVERNAME, OnKillfocusEditDrivername)
	ON_BN_CLICKED(IDC_BUTTON_SAVE, OnButtonSave)
	ON_EN_KILLFOCUS(IDC_EDIT_VENDAX, OnKillfocusEditVendax)
	ON_BN_CLICKED(IDC_BUTTON_BROWSE_VENDAX, OnButtonBrowseVendax)
	ON_EN_KILLFOCUS(IDC_EDIT_CONFIG_STRING, OnKillfocusEditConfigString)
	ON_BN_CLICKED(IDC_BUTTON_RESET, OnButtonReset)
	ON_BN_CLICKED(IDC_BUTTON_FIND_DEVICES, OnButtonFindDevices)
	ON_BN_CLICKED(IDC_CHECK1, OnCheck1)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_RADIO1, &Setup::OnBnClickedRadioInterfaceType0)
	ON_BN_CLICKED(IDC_RADIO2, &Setup::OnBnClickedRadioInterfaceType1)
	ON_BN_CLICKED(IDC_RADIO3, &Setup::OnBnClickedRadioInterfaceType2)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Setup message handlers

/////////////////////////////////////////////////////////////////////////////
// When we become active, display the current data values

BOOL Setup::OnSetActive() 
{
	CWnd *pWnd = GetDlgItem(IDC_EDIT_DRIVERNAME);
	ASSERT_VALID(pWnd);
	pWnd->SetWindowText(pcDriverName);

	pWnd = GetDlgItem(IDC_EDIT_VENDAX);
	ASSERT_VALID(pWnd);
	pWnd->SetWindowText(m_AxFilename);

	pWnd = GetDlgItem(IDC_EDIT_CONFIG_STRING);
	ASSERT_VALID(pWnd);
	pWnd->SetWindowText( m_ConfigFilename );

	CButton *pButton = (CButton *)GetDlgItem( IDC_CHECK1 );
	pButton->EnableWindow( bSupport9912 );
	pButton->SetCheck( b_9912 ? BST_CHECKED : BST_UNCHECKED );

	pButton = (CButton *)GetDlgItem( IDC_RADIO1 );
	pButton->SetCheck( nInterfaceType == INTERFACE_N2PK ? BST_CHECKED : BST_UNCHECKED );
	pButton = (CButton *)GetDlgItem( IDC_RADIO2 );
	pButton->SetCheck( nInterfaceType == INTERFACE_HPIB ? BST_CHECKED : BST_UNCHECKED );
	pButton = (CButton *)GetDlgItem( IDC_RADIO3 );
	pButton->SetCheck( nInterfaceType == INTERFACE_MSA ? BST_CHECKED : BST_UNCHECKED );

	return CPropertyPage::OnSetActive();
}

/////////////////////////////////////////////////////////////////////////////
// If the drivername edit box had focus and just lost it, update the stored
// driver name just in case it changed.

void Setup::OnKillfocusEditDrivername() 
{
	CString sTemp;
	CWnd *pWnd = GetDlgItem(IDC_EDIT_DRIVERNAME);
	ASSERT_VALID(pWnd);
	pWnd->GetWindowText(sTemp);
	if( sTemp.GetLength() < MAX_DRIVER_NAME - 4 )
		pcDriverName = sTemp;
	else
		pWnd->SetWindowText( pcDriverName );
}

/////////////////////////////////////////////////////////////////////////////
// If they click SAVE then store the current values in the registry
// If any write fails display an error message at the end

void Setup::OnButtonSave() 
{
	bool bError = false;
	CString sSetup, sToken;

	sSetup.LoadString(IDS_STRING_SETUP);
	sToken.LoadString(IDS_DRIVER_FILENAME);
	if( !AfxGetApp( )->WriteProfileString( sSetup, sToken, pcDriverName ))
		bError = true;
	sToken.LoadString(IDS_VENDAX_FILENAME);
	if( !AfxGetApp( )->WriteProfileString( sSetup, sToken, m_AxFilename ))
		bError = true;
	sToken.LoadString(IDS_N2PK_CONFIG_NAME);
	if( !AfxGetApp( )->WriteProfileString( sSetup, sToken, m_ConfigFilename ))
		bError = true;
	sToken.LoadString(IDS_N2PK_CONFIG_9912);
	if( !AfxGetApp( )->WriteProfileInt( sSetup, sToken, b_9912 ))
		bError = true;
	sToken.LoadString(IDS_N2PK_CYUSB_INDEX);
	if( !AfxGetApp( )->WriteProfileInt( sSetup, sToken, nCyUsbDevice ))
		bError = true;
	sToken.LoadString(IDS_N2PK_CYUSB_N2PK_GUID);
	if( !AfxGetApp( )->WriteProfileInt( sSetup, sToken, bUsingN2pkGUID ))
		bError = true;
	sToken.LoadString(IDS_N2PK_CYUSB_MSA_GUID);
	if( !AfxGetApp( )->WriteProfileInt( sSetup, sToken, bUsingMsaGUID ))
		bError = true;
	sToken.LoadString(IDS_N2PK_USE_CYUSB);
	if( !AfxGetApp( )->WriteProfileInt( sSetup, sToken, bUsingCyUSB ))
		bError = true;
	sToken.LoadString(IDS_N2PK_SUPPORT_9912);
	if( !AfxGetApp( )->WriteProfileInt( sSetup, sToken, bSupport9912 ))
		bError = true;
	sToken.LoadString(IDS_N2PK_INTERFACE_TYPE);
	if( !AfxGetApp( )->WriteProfileInt( sSetup, sToken, nInterfaceType ))
		bError = true;
	
	if( bError )
		AfxMessageBox( IDS_CANNOT_WRITE_REGISTRY, MB_OK );
}

/////////////////////////////////////////////////////////////////////////////
// If the vendax edit box had focus and just lost it, update the stored
// file name just in case it changed.

void Setup::OnKillfocusEditVendax() 
{
	CWnd *pWnd = GetDlgItem(IDC_EDIT_VENDAX);
	ASSERT_VALID(pWnd);
	pWnd->GetWindowText(m_AxFilename);
}

/////////////////////////////////////////////////////////////////////////////
// If they want to browse for a vendax filename use the file dialog to 
// get a new filename and store / display the result

void Setup::OnButtonBrowseVendax() 
{
    if (!UpdateData(TRUE))
        return;

    CFileDialog dlg1( TRUE,"hex",NULL,
	                 OFN_HIDEREADONLY|OFN_NONETWORKBUTTON|OFN_FILEMUSTEXIST,
	                 _T("ENR Data File (*.hex)|*.hex|Any File Extension|*.*||"));
	
	if( dlg1.DoModal()!=IDOK )
		return;

   	m_AxFilename=dlg1.GetPathName();

	CWnd* pWnd = GetDlgItem(IDC_EDIT_VENDAX);
	ASSERT_VALID(pWnd);
	pWnd->SetWindowText( m_AxFilename );

	UpdateData(FALSE);	// Set the edit box to the filename
	
}

/////////////////////////////////////////////////////////////////////////////
// If the config edit box had focus and just lost it, update the stored
// config string name just in case it changed.

void Setup::OnKillfocusEditConfigString() 
{
	CWnd* pWnd = GetDlgItem(IDC_EDIT_CONFIG_STRING);
	ASSERT_VALID(pWnd);
	pWnd->GetWindowText( m_ConfigFilename );
}

/////////////////////////////////////////////////////////////////////////////
// On reset, restore the original values.

void Setup::OnButtonReset() 
{
	switch( nInterfaceType )
	{
	case INTERFACE_N2PK:
		m_ConfigFilename = b_9912 ? "9912 VNA" : "N2PK VNA";
		break;
	case INTERFACE_HPIB:
		m_ConfigFilename = "G8KBB HPIB";
		break;
	case INTERFACE_MSA:
		m_ConfigFilename = "MSA FW";
		break;
	default:
		m_ConfigFilename = "Unknown";
	}
//	pcDriverName = BASE_EZUSB_NAME;
//	CWnd *pWnd = GetDlgItem(IDC_EDIT_DRIVERNAME);
//	ASSERT_VALID(pWnd);
//	pWnd->SetWindowText(pcDriverName);

	//m_AxFilename = "Vend_Ax.hex";
	//CWnd *pWnd = GetDlgItem(IDC_EDIT_VENDAX);
	//ASSERT_VALID(pWnd);
	//pWnd->SetWindowText(m_AxFilename);

	CWnd *pWnd = GetDlgItem(IDC_EDIT_CONFIG_STRING);
	ASSERT_VALID(pWnd);
	pWnd->SetWindowText( m_ConfigFilename );
}

/////////////////////////////////////////////////////////////////////////////
// If they want to find available devices used the FindDevices code to get one

void Setup::OnButtonFindDevices() 
{
	CFindDevices rawDialog;
	int iResult;
	CString sTemp;

	iResult = rawDialog.DoModal();
	if( iResult == IDOK )
	{
		CWnd *pWnd = GetDlgItem(IDC_EDIT_DRIVERNAME);
		ASSERT_VALID(pWnd);
		pWnd->SetWindowText(pcDriverName);
	}
}

void Setup::OnCheck1() 
{
	b_9912 = !b_9912;
	CButton *pButton = (CButton *)GetDlgItem( IDC_CHECK1 );
	pButton->SetCheck( b_9912 ? BST_CHECKED : BST_UNCHECKED );
	
}

void Setup::OnBnClickedRadioInterfaceType0()
{
	nInterfaceType = INTERFACE_N2PK;
	OnButtonReset();
}

void Setup::OnBnClickedRadioInterfaceType1()
{
	nInterfaceType = INTERFACE_HPIB;
	OnButtonReset();
}

void Setup::OnBnClickedRadioInterfaceType2()
{
	nInterfaceType = INTERFACE_MSA;
	OnButtonReset();
}
