// Program.cpp : implementation file
//
//(C) Copyright Dave Roberts G8KBB 2005
// This program is released only for the purpose of self training and eduation
// in amatuer radio. It may not be used for any commercial purpose, sold or
// modified.
// It has been written as an exercise in self tuition by me as part of my hobby
// and I make no claims about its fitness for purpose or correct operation.


#include "stdafx.h"
#include "usb configure.h"
#include "Program.h"

#include "common.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern int b_9912;

/////////////////////////////////////////////////////////////////////////////
// CProgram property page

IMPLEMENT_DYNCREATE(CProgram, CPropertyPage)

CProgram::CProgram() : CPropertyPage(CProgram::IDD)
{
	//{{AFX_DATA_INIT(CProgram)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

CProgram::~CProgram()
{
}

void CProgram::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CProgram)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CProgram, CPropertyPage)
	//{{AFX_MSG_MAP(CProgram)
	ON_CBN_SELENDOK(IDC_COMBO_PROGRAM_OPTION, OnSelendokComboProgramOption)
	ON_EN_KILLFOCUS(IDC_EDIT_DATA_WRITE, OnKillfocusEditDataWrite)
	ON_BN_CLICKED(IDC_BUTTON_CHECK, OnButtonCheck)
	ON_BN_CLICKED(IDC_BUTTON_DOWNLOAD, OnButtonDownload)
	ON_BN_CLICKED(IDC_BUTTON_READ, OnButtonRead)
	ON_BN_CLICKED(IDC_BUTTON_WRITE, OnButtonWrite)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CProgram message handlers

// *************************************************************************
// populate dialogs on initialisation

// This structure defines one entry in the next table. Each entry in the table
// has a desciption (an entry in the string table) and an 8 byte data value

struct ProgramOptions 
{
	int nLabel;
	BYTE data[PROGRAM_DATA_SIZE];
};

// This is the table itself.
// note drop down list of options - penultimate entry must be the user choice entry
// the data value is ignored for this one
// Last entry must end with a label of 0

struct ProgramOptions nProgramOptionsN2PK[] =
{
	IDS_LIST_ERASE, { 0xFF, 0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF },
	IDS_LIST_N2PK_VNA, { 0xC0, 0x47, 0x05, 0x04, 0x10, 0x01, 0x00, 0x00 },
	IDS_LIST_N2PK_VNA500, { 0xC0, 0x47, 0x05, 0x08, 0x10, 0x01, 0x00, 0x00 },
	IDS_LIST_N2PK_VNAV5, { 0xC0, 0x47, 0x05, 0x0a, 0x10, 0x01, 0x00, 0x00 },
	IDS_LIST_N2PK_VNAV5_500, { 0xC0, 0x47, 0x05, 0x0c, 0x10, 0x01, 0x00, 0x00 },
	IDS_LIST_UserChoice, { 0 },
	0, { 0 }
};

struct ProgramOptions nProgramOptions9912[] =
{
	IDS_LIST_ERASE, { 0xFF, 0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF },
	IDS_LIST_N2PK_VNA, { 0xC0, 0x47, 0x05, 0x04, 0x10, 0x01, 0x00, 0x00 },
	IDS_LIST_N2PK_VNA500, { 0xC0, 0x47, 0x05, 0x08, 0x10, 0x01, 0x00, 0x00 },
	IDS_LIST_N2PK_VNAV5, { 0xC0, 0x47, 0x05, 0x0a, 0x10, 0x01, 0x00, 0x00 },
	IDS_LIST_N2PK_VNAV5_500, { 0xC0, 0x47, 0x05, 0x0c, 0x10, 0x01, 0x00, 0x00 },
	IDS_LIST_9912VNA, { 0xC0, 0x47, 0x05, 0x0e, 0x10, 0x01, 0x00, 0x00 },
	IDS_LIST_UserChoice, { 0 },
	0, { 0 }
};

struct ProgramOptions nProgramOptionsHPIB[] =
{
	IDS_LIST_ERASE, { 0xFF, 0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF },
	IDS_LIST_IEEE488, { 0xC0, 0x47, 0x05, 0x06, 0x10, 0x01, 0x00, 0x00 },
	IDS_LIST_UserChoice, { 0 },
	0, { 0 }
};

struct ProgramOptions nProgramOptionsMSA[] =
{
	IDS_LIST_ERASE, { 0xFF, 0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF },
	IDS_LIST_MSA, { 0xC0, 0x47, 0x05, 0x12, 0x10, 0x01, 0x00, 0x00 },
	IDS_LIST_UserChoice, { 0 },
	0, { 0 }
};

struct ProgramOptions nProgramOptionsBlank[] =
{
	IDS_LIST_ERASE, { 0xFF, 0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF },
	IDS_LIST_UserChoice, { 0 },
	0, { 0 }
};


/////////////////////////////////////////////////////////////////////////////
// On startup populate the combo box with the above choices

BOOL CProgram::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();

	InitDropdown();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


// initialise the dropdown list of valus tht may be written

void CProgram::InitDropdown()
{
	CString sTemp;
	int i;
	struct ProgramOptions *pOption;
	switch( nInterfaceType )
	{
	case INTERFACE_N2PK:
		if( b_9912 )
			pOption = &nProgramOptions9912[0];
		else
			pOption = &nProgramOptionsN2PK[0];
		break;
	case INTERFACE_HPIB:
		pOption = &nProgramOptionsHPIB[0];
		break;
	case INTERFACE_MSA:
		pOption = &nProgramOptionsMSA[0];
		break;
	default:
		pOption = &nProgramOptionsBlank[0];
	}
	CWnd *pWnd = GetDlgItem(IDC_COMBO_PROGRAM_OPTION);
	ASSERT_VALID(pWnd);

	pWnd->SendMessage(CB_RESETCONTENT, 0, 0);
	for( i=0; pOption[i].nLabel != 0 && i < (sizeof(nProgramOptions9912)/sizeof(struct ProgramOptions)); i++)
	{
		sTemp.LoadString( pOption[i].nLabel );
		pWnd->SendMessage(CB_ADDSTRING, 0, (LPARAM)((LPCTSTR)sTemp));
	}
	pWnd->SendMessage(CB_SETCURSEL, (WPARAM)0, 0);
}


/////////////////////////////////////////////////////////////////////////////
// OK, they changed the currently selected option in the combo box
// Get the current entry index and use that to get the binary data
// Format that data as HEX ASCII and display it
// then enable the check button if it was the user edit choice
// and the write option for a predefined value

void CProgram::OnSelendokComboProgramOption() 
{
	int i;
	CString sValue, sTemp;
	bool bUserValue;

	// We presume that the drop down list value is the one they want
	// and we read its index. This is used to get the table binary data.

	CWnd *pWnd = GetDlgItem(IDC_COMBO_PROGRAM_OPTION);
	ASSERT_VALID(pWnd);
	i = pWnd->SendMessage(CB_GETCURSEL, 0, 0);

	if( i == CB_ERR )
		return;
	
	struct ProgramOptions *pOption;
	switch( nInterfaceType )
	{
	case INTERFACE_N2PK:
		if( b_9912 )
		{	pOption = &nProgramOptions9912[0];
			bUserValue = ( i == (sizeof(nProgramOptions9912)/sizeof(struct ProgramOptions))-2) ;
		}
		else
		{
			pOption = &nProgramOptionsN2PK[0];
			bUserValue = ( i == (sizeof(nProgramOptionsN2PK)/sizeof(struct ProgramOptions))-2) ;
		}
		break;
	case INTERFACE_HPIB:
		pOption = &nProgramOptionsHPIB[0];
		bUserValue = ( i == (sizeof(nProgramOptionsHPIB)/sizeof(struct ProgramOptions))-2) ;
		break;
	case INTERFACE_MSA:
		pOption = &nProgramOptionsMSA[0];
		bUserValue = ( i == (sizeof(nProgramOptionsMSA)/sizeof(struct ProgramOptions))-2) ;
		break;
	default:
		pOption = &nProgramOptionsBlank[0];
		bUserValue = ( i == (sizeof(nProgramOptionsBlank)/sizeof(struct ProgramOptions))-2) ;
	}
	pWnd = GetDlgItem(IDC_EDIT_DATA_WRITE);
	ASSERT_VALID(pWnd);
	pWnd->EnableWindow( bUserValue );

	for( int j=0; j< PROGRAM_DATA_SIZE; j++)
	{
		sTemp.Format("%02X ", pOption[i].data[j] );
		sValue += sTemp;
	}
	pWnd->SetWindowText(sValue);
	pWnd = GetDlgItem( IDC_BUTTON_CHECK );
	ASSERT_VALID(pWnd);
	pWnd->EnableWindow( bUserValue );
	pWnd = GetDlgItem( IDC_BUTTON_WRITE );
	ASSERT_VALID(pWnd);
	pWnd->EnableWindow( !bUserValue );

}

/////////////////////////////////////////////////////////////////////////////
// They (possibly) changed the data to be written (well, the edit box just
// lost focus so let's assume so and go read and reformat the data
// We get the text and then parse it into bytes with spaces.
// If they enter data without spaces just space it out

void CProgram::OnKillfocusEditDataWrite() 
{
//	CException ex;
	CString sTemp;
	CString sNew;
	bool bFaulty = false;

	CWnd *pWnd = GetDlgItem(IDC_EDIT_DATA_WRITE);
	ASSERT_VALID(pWnd);
	pWnd->GetWindowText( sTemp );

	sTemp.TrimLeft();
	sTemp.TrimRight();
	LPTSTR pStr = sTemp.GetBuffer(100);
	int nByteCount = 0;
	while( *pStr != '\0'  && nByteCount < 8 )
	{
		if( isxdigit( *pStr ))
		{
			if( isxdigit( *(pStr+1) ))
			{
				sNew += *pStr;
				sNew += *(pStr+1);
				sNew += ' ';
				pStr += 2;
				nByteCount++;
			}
			else if( *(pStr+1) == ' ' || *(pStr+1) == '\0')
			{
				sNew += '0';
				sNew += *(pStr);
				sNew += ' ';
				pStr++;
				nByteCount++;
			}
			// else error or eof
		}
		else if( *pStr == ' ')
			pStr++;
		else
		{
			AfxMessageBox(IDS_WRITE_DATA_ERROR, MB_OK );
			pWnd->SetFocus();
			return;
		}
	}

	// less than 8 ? pad with zeros.

	while( nByteCount < 8 )
	{
		sNew += "00 ";
		nByteCount++;
	}
	pWnd->SetWindowText( sNew );
}

/////////////////////////////////////////////////////////////////////////////
// They clicked check. We just want them to think about it so they need to do this
// and the loss of focus from the edit box will reformat the data.
// We now just tell then to check it and enable the program button.

void CProgram::OnButtonCheck() 
{
	CString sStatus;

	CEdit* pWndS = (CEdit *)GetDlgItem(IDC_EDIT_STATUS);
	ASSERT_VALID(pWndS);
	sStatus.LoadString( IDS_WRITE_USER_WARNING );
	pWndS->SetWindowText(sStatus);
	
	
	CWnd *pWnd = GetDlgItem( IDC_BUTTON_WRITE );
	ASSERT_VALID(pWnd);
	pWnd->EnableWindow( true );
}

/////////////////////////////////////////////////////////////////////////////
// This is the first thing they must do. Download the vend_ax program so we can
// access eeprom. Only if this succeeds do we enable the other functions

void CProgram::OnButtonDownload() 
{
	CEdit* pWnd = (CEdit *)GetDlgItem(IDC_EDIT_STATUS);
	ASSERT_VALID(pWnd);

	int i = DownloadFile( pWnd, m_AxFilename );

	if (i==TRUE)
	{
		CWnd *pWnd = GetDlgItem( IDC_BUTTON_READ );
		ASSERT_VALID(pWnd);
		pWnd->EnableWindow( true);
		pWnd = GetDlgItem( IDC_COMBO_PROGRAM_OPTION );
		ASSERT_VALID(pWnd);
		pWnd->EnableWindow( true );
		// update data selected for programming
		OnSelendokComboProgramOption();
	}
}

/////////////////////////////////////////////////////////////////////////////
// When we become active we want to make sure that they download vend_ax first
// so disable the other functions, clean up displated data and wait for
// then to do the doenload.

BOOL CProgram::OnSetActive() 
{
	CWnd *pWnd = GetDlgItem( IDC_BUTTON_READ );
	ASSERT_VALID(pWnd);
	pWnd->EnableWindow( false );
	pWnd = GetDlgItem( IDC_BUTTON_CHECK );
	ASSERT_VALID(pWnd);
	pWnd->EnableWindow( false );

	// update data selected for programming
	OnSelendokComboProgramOption();

	pWnd = GetDlgItem( IDC_BUTTON_WRITE );
	ASSERT_VALID(pWnd);
	pWnd->EnableWindow( false );
	pWnd = GetDlgItem( IDC_COMBO_PROGRAM_OPTION );
	ASSERT_VALID(pWnd);
	pWnd->EnableWindow( false );
	
	pWnd = GetDlgItem(IDC_EDIT_STATUS);
	ASSERT_VALID(pWnd);
	pWnd->SetWindowText("");

	InitDropdown();

	return CPropertyPage::OnSetActive();
}

/////////////////////////////////////////////////////////////////////////////
// Read eeprom data.
// This uses vend_ax request A2. Note the index is HARD CODED

void CProgram::OnButtonRead() 
{
	VENDOR_OR_CLASS_REQUEST_CONTROL	myRequest;
    char buffer[8];
    ULONG bufferSize = 0;
	long nBytes;
	HANDLE hDevice;
	CString sStatus;
	BOOL bResult;
                
	CEdit* pWnd = (CEdit *)GetDlgItem(IDC_EDIT_STATUS);
	ASSERT_VALID(pWnd);
      
	if( bUsingCyUSB )
	{
		CCyControlEndPoint *ept;
		ept = USBDevice->ControlEndPt;
		ept->Target = TGT_DEVICE;
		ept->ReqType = REQ_VENDOR;
		ept->Direction = DIR_FROM_DEVICE;
		ept->ReqCode = 0xA2;
		ept->Value = 0;
		ept->Index = 0xBEEF;
		nBytes = sizeof( buffer );
		bResult = ept->Read( (PUCHAR)buffer, nBytes ); // >XferData(&data, len);	}
	}
	else
	{
		// Open the driver
		if (bOpenDriver (&hDevice, (LPTSTR)(LPCTSTR)pcDriverName) != TRUE)
		{
			sStatus.LoadString( IDS_OPEN_DRIVER_FAIL );
			pWnd->SetWindowText(sStatus);
			hDevice = NULL;
		}

		myRequest.request = 0xA2;
		myRequest.value = (USHORT)0;
		myRequest.index = (USHORT)0xBEEF;
		myRequest.direction = 1;
		myRequest.requestType=2; // vendor specific request type (2)
		myRequest.recepient=0; // recepient is device (0)
					
		if (hDevice != NULL) 
		{
			bResult = DeviceIoControl (hDevice,
					IOCTL_EZUSB_VENDOR_OR_CLASS_REQUEST,
					&myRequest,
					sizeof(VENDOR_OR_CLASS_REQUEST_CONTROL),
					buffer,
					sizeof(buffer),
					(unsigned long *)&nBytes,
					NULL);
		}/* if valid driver handle */
	}

    if (bResult==TRUE)
    {
		CEdit *pWnd2 = (CEdit *)GetDlgItem(IDC_EDIT_DATA_READ);
		ASSERT_VALID(pWnd2);
		DumpBuffer(buffer,nBytes,&sStatus);
		pWnd2->SetWindowText(sStatus);
    }
    else
	{
		sStatus.LoadString( IDS_VENDAX_READ_FAIL );
		pWnd->SetWindowText(sStatus);
		hDevice = NULL;
	}
    if( !bUsingCyUSB )
		CloseHandle (hDevice);
}

/////////////////////////////////////////////////////////////////////////////
// Now the big one - program.
// Go read the data from the write edit box and turn it into binary.
// then try to write it. Again the vend_ax function A2 is used with a 
// hard coded index.
// If the write succeeds clear the read data edit box to make it easier
// to check that the write worked by doing a read.

void CProgram::OnButtonWrite() 
{
	VENDOR_OR_CLASS_REQUEST_CONTROL	myRequest;
    ULONG bufferSize = 0;
	long nBytes;
	HANDLE hDevice;
	CString sStatus, sTemp;
	BOOL bResult;
                
	int i,j;
	char c;
	char buffer[16*3+1];

	CWnd *pWndW = GetDlgItem( IDC_EDIT_DATA_WRITE );
	ASSERT_VALID(pWndW);
	pWndW->GetWindowText( buffer, sizeof(buffer) );

	CEdit* pWndS = (CEdit *)GetDlgItem(IDC_EDIT_STATUS);
	ASSERT_VALID(pWndS);

	for( i=0, j=0; buffer[i] != '\0'; i++)
	{
		c = buffer[i];
		if( isspace( c ))
			continue;
		if( !isxdigit( c ) )
		{
			sStatus.LoadString( IDS_NONHEX_DATA );
			pWndS->SetWindowText(sStatus);
			return;
		}
		c -= '0';
		if( c > 9 ) 
			c-= ('A'-'0'-10);
		if( j & 1 )
			WriteBuffer[j/2] = (WriteBuffer[j/2] << 4) + c;
		else
			WriteBuffer[j/2] = c;
		j++;
	}
	if( j & 1 )
		j++;
	WriteBufferSize = j / 2;

	sStatus.LoadString( IDS_DATA_TO_LOAD );
	DumpBuffer(WriteBuffer,WriteBufferSize,&sStatus);
	sStatus += "\r\n";

	if( bUsingCyUSB )
	{
		CCyControlEndPoint *ept;
		ept = USBDevice->ControlEndPt;
		ept->Target = TGT_DEVICE;
		ept->ReqType = REQ_VENDOR;
		ept->Direction = DIR_TO_DEVICE;
		ept->ReqCode = 0xA2;
		ept->Value = 0;
		ept->Index = 0xBEEF;
		nBytes = WriteBufferSize;
		bResult = ept->Write( (PUCHAR)WriteBuffer, nBytes ); // >XferData(&data, len);	}
	}
	else
	{
		// Open the driver
		if (bOpenDriver (&hDevice, (LPTSTR)(LPCTSTR)pcDriverName) != TRUE)
		{
			sTemp.LoadString( IDS_OPEN_DRIVER_FAIL );
			sStatus += sTemp;
			pWndS->SetWindowText(sStatus);
			hDevice = NULL;
		}

		myRequest.request = 0xA2;
		myRequest.value = (USHORT)0;
		myRequest.index = (USHORT)0xBEEF;
		myRequest.direction = 0;
		myRequest.requestType=2; // vendor specific request type (2)
		myRequest.recepient=0; // recepient is device (0)
					
		if (hDevice != NULL) 
		{
			bResult = DeviceIoControl (hDevice,
					IOCTL_EZUSB_VENDOR_OR_CLASS_REQUEST,
					&myRequest,
					sizeof(VENDOR_OR_CLASS_REQUEST_CONTROL),
					WriteBuffer,
					WriteBufferSize,
					(unsigned long *)&nBytes,
					NULL);
		}
	}

    if (bResult==TRUE)
	{
		CEdit *pWnd2 = (CEdit *)GetDlgItem(IDC_EDIT_DATA_READ);
		ASSERT_VALID(pWnd2);
		pWnd2->SetWindowText("");
		sTemp.LoadString( IDS_VENDAX_WRITE_SUCCEED);
    }
	else
		sTemp.LoadString( IDS_VENDAX_WRITE_FAIL );
	sStatus += sTemp;
	pWndS->SetWindowText(sStatus);
	hDevice = NULL;
	if( ! bUsingCyUSB )
		CloseHandle (hDevice);
}
