// Download.cpp : implementation file
//
//(C) Copyright Dave Roberts G8KBB 2005
// This program is released only for the purpose of self training and eduation
// in amatuer radio. It may not be used for any commercial purpose, sold or
// modified.
// It has been written as an exercise in self tuition by me as part of my hobby
// and I make no claims about its fitness for purpose or correct operation.


#include "stdafx.h"
#include "usb configure.h"
#include "Download.h"

#include "common.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDownload property page

IMPLEMENT_DYNCREATE(CDownload, CPropertyPage)

CDownload::CDownload() : CPropertyPage(CDownload::IDD)
{
	//{{AFX_DATA_INIT(CDownload)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

CDownload::~CDownload()
{
}

void CDownload::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDownload)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDownload, CPropertyPage)
	//{{AFX_MSG_MAP(CDownload)
	ON_BN_CLICKED(IDC_BUTTON_BrowseFilename, OnBUTTONBrowseFilename)
	ON_BN_CLICKED(IDC_BUTTON2, OnButtonDownload)
	ON_EN_KILLFOCUS(IDC_EDITDownloadFilename, OnKillfocusEDITDownloadFilename)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDownload message handlers

// **************************************************************************
// user clicks browse button for filename. 

void CDownload::OnBUTTONBrowseFilename() 
{
    if (!UpdateData(TRUE))
        return;

    CFileDialog dlg1( TRUE,"log",NULL,
	                 OFN_HIDEREADONLY|OFN_NONETWORKBUTTON|OFN_FILEMUSTEXIST,
	                 _T("FX2 Executable File (*.hex)|*.hex|Any File Extension|*.*||"));
	
	if( dlg1.DoModal()!=IDOK )
		return;

   	m_LogFilename=dlg1.GetPathName();

	CWnd* pWnd = GetDlgItem(IDC_EDITDownloadFilename);
	ASSERT_VALID(pWnd);
	pWnd->SetWindowText( m_LogFilename );

	UpdateData(FALSE);	// Set the edit box to the filename
	
}

// **************************************************************************
// user may have edited filename. Update stored filename 

void CDownload::OnKillfocusEDITDownloadFilename() 
{
	CWnd* pWnd = GetDlgItem(IDC_EDITDownloadFilename);
	ASSERT_VALID(pWnd);
	char szTemp[FILENAME_MAX];

	pWnd->GetWindowText(szTemp, sizeof(szTemp)-1 );
	m_LogFilename = szTemp;
	m_LogFilename.TrimLeft();
	m_LogFilename.TrimRight();
	pWnd->SetWindowText( m_LogFilename );
}

// **************************************************************************
// download file to fx2

void CDownload::OnButtonDownload() 
{
	CEdit* pWnd = (CEdit *)GetDlgItem(IDC_Edit_DownloadStatus);
	ASSERT_VALID(pWnd);

	if( strlen( m_LogFilename ) < 1 )
	{
		AfxMessageBox(IDS_NEED_FILENAME, MB_OK );
		return;
	}

	DownloadFile( pWnd, m_LogFilename );
}
		  
// **************************************************************************
// When we become active, clear any old status messages

BOOL CDownload::OnSetActive() 
{
	CEdit* pWnd = (CEdit *)GetDlgItem(IDC_Edit_DownloadStatus);
	ASSERT_VALID(pWnd);
	pWnd->SetWindowText("");
	
	return CPropertyPage::OnSetActive();
}


