// Communicate.cpp : implementation file
//
//(C) Copyright Dave Roberts G8KBB 2005
// This program is released only for the purpose of self training and eduation
// in amatuer radio. It may not be used for any commercial purpose, sold or
// modified.
// It has been written as an exercise in self tuition by me as part of my hobby
// and I make no claims about its fitness for purpose or correct operation.


#include "stdafx.h"
#include "usb configure.h"
#include "Communicate.h"
#include "buildraw.h"
#include "buildset.h"

#include "common.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

char PIPE_TYPE_STRINGS[4][4] = 
{
"CTL",
"ISO",
"BLK",
"INT"
};

char PIPE_DIRECTION[2][4] = 
{
"OUT",
"IN "
};

extern int b_9912;

/////////////////////////////////////////////////////////////////////////////
// CCommunicate property page

IMPLEMENT_DYNCREATE(CCommunicate, CPropertyPage)

CCommunicate::CCommunicate() : CPropertyPage(CCommunicate::IDD)
{
	//{{AFX_DATA_INIT(CCommunicate)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

CCommunicate::~CCommunicate()
{
}

void CCommunicate::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCommunicate)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCommunicate, CPropertyPage)
	//{{AFX_MSG_MAP(CCommunicate)
	ON_BN_CLICKED(IDC_BUTTON_READ, OnButtonReadVNA)
	ON_BN_CLICKED(IDC_BUTTON_CHECK, OnButtonCheck)
	ON_BN_CLICKED(IDC_BUTTON_WRITE, OnButtonWrite)
	ON_BN_CLICKED(IDC_BUTTON_BUILD_RAW, OnButtonBuildRaw)
	ON_BN_CLICKED(IDC_BUTTON_BUILD_SET, OnButtonBuildSet)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCommunicate message handlers

void CCommunicate::OnButtonReadVNA() 
{

	int length;
	char buffer[256];
	unsigned long nBytes;
	HANDLE hDevice;
	CString sStatus;
	BULK_TRANSFER_CONTROL bulkControl;
	bool bResult;

	CEdit* pWnd = (CEdit *)GetDlgItem(IDC_EDIT_MESSAGES);
	ASSERT_VALID(pWnd);
	pWnd->FmtLines( true );

	if( bUsingCyUSB )
	{
		bResult = USBDevice->Open( nCyUsbDevice );
		if( bResult )
		{
			long len = 255;
			if( USBDevice->BulkInEndPt )
				bResult = USBDevice->BulkInEndPt->XferData( (PUCHAR)buffer, len );
			nBytes = len;
		}
	}
	else
	{
		if (bOpenDriver (&hDevice, (LPTSTR)(LPCTSTR)pcDriverName) != TRUE)
		{
			sStatus.LoadString( IDS_OPEN_DRIVER_FAIL );
			pWnd->SetWindowText(sStatus);
			hDevice = NULL;
			return;
		}
		// TODO - Sort this out
		bulkControl.pipeNum = 1;
		length = 255;

		if (hDevice != NULL) 
		{
			bResult = ( 0 != DeviceIoControl (hDevice,
							IOCTL_EZUSB_BULK_READ, 
							&bulkControl,
							sizeof (BULK_TRANSFER_CONTROL),
							buffer,
							length,
							(unsigned long *)&nBytes,
							NULL));
			CloseHandle (hDevice);
		}
	}
	if( bResult )
	{
		DumpBuffer(buffer, nBytes, &sStatus);
		CEdit* pWnd = (CEdit *)GetDlgItem(IDC_EDIT_READ);
		ASSERT_VALID(pWnd);
		pWnd->FmtLines( true );
		pWnd->SetWindowText(sStatus);
	}
	else
	{
		sStatus.LoadString( IDS_READ_USB_ERROR );
		pWnd->SetWindowText(sStatus);
	}
}

BOOL CCommunicate::OnSetActive() 
{
	ConfigureDialog( false );

	CWnd *pWnd = GetDlgItem(IDC_EDIT_MESSAGES);
	ASSERT_VALID(pWnd);
	pWnd->SetWindowText("");

	return CPropertyPage::OnSetActive();
}

void CCommunicate::OnButtonCheck() 
{
	CString sStatus, sTemp;
    HANDLE  hDevice = NULL;
	bool bResult;
	unsigned long nBytes;
	UCHAR InterfaceInfo[1024];
	PUSBD_INTERFACE_INFORMATION pInterface;
	PUSBD_PIPE_INFORMATION pPipe;
	bool bN2pkVnaFound;


	CEdit* pWnd = (CEdit *)GetDlgItem(IDC_EDIT_MESSAGES);
	ASSERT_VALID(pWnd);
	pWnd->FmtLines( true );

	if( bUsingCyUSB )
	{
		bResult = USBDevice->Open( nCyUsbDevice );
	}
	else
	{
		if (bOpenDriver (&hDevice, (LPTSTR)(LPCTSTR)pcDriverName) != TRUE)
		{
			sStatus.LoadString( IDS_OPEN_DRIVER_FAIL );
			pWnd->SetWindowText(sStatus);
			hDevice = NULL;
			return;
		}
		bResult = true;
	}
	if( bResult )
	{
		// The string descriptor is obtained using two separate calls.  The
		// first call is done to determine the size of the entire string descriptor,
		// and the second call is done with that total size specified.  
		// For more information, please refer to the USB Specification, Chapter 9.

		GET_STRING_DESCRIPTOR_IN input;
		input.LanguageId = 27;
		input.Index = 1;

		bResult = GetStringDescriptor( hDevice, &input, &sTemp );
		sStatus += sTemp;
		pWnd->SetWindowText(sStatus);
		input.Index = 2;
		bResult = GetStringDescriptor( hDevice, &input, &sTemp );
		sStatus += sTemp;
		pWnd->SetWindowText(sStatus);

		bN2pkVnaFound = ( sTemp.Find(m_ConfigFilename) != -1 );

		if( bResult == 0 )
		{
			if( !bUsingCyUSB )
				CloseHandle (hDevice);
			hDevice = NULL;
		}
		
		if (bResult) 
		{
			if( bUsingCyUSB)
			{
				int i;
				for(i=1; i< USBDevice->EndPointCount();i++)
				{
					sTemp.Format("Endpoint: %2d, Type %s, Endpoint %2d %s Max Packet Size 0x%x\r\n", 
						i, 
						PIPE_TYPE_STRINGS[USBDevice->EndPoints[i]->Attributes & 3],
						USBDevice->EndPoints[i]->Address & 0x0f,
						PIPE_DIRECTION[(USBDevice->EndPoints[i]->Address >> 7)&1],
						USBDevice->EndPoints[i]->MaxPktSize );
					sStatus += sTemp;
				}
				pWnd->SetWindowText(sStatus);
			}
			else
			{
				bResult = ( 0 != DeviceIoControl (hDevice,
						IOCTL_Ezusb_GET_PIPE_INFO,
						NULL,
						0,
						InterfaceInfo,
						sizeof(InterfaceInfo),
						(unsigned long *)&nBytes,
						NULL));
				if (bResult)
				{
					int i;
					pInterface = (PUSBD_INTERFACE_INFORMATION) InterfaceInfo;
					pPipe = pInterface->Pipes;

					for (i = 0; i < (int) pInterface->NumberOfPipes; i++)
					{
						sTemp.Format("Pipe: %2d, Type %s, Endpoint %2d %s Max Packet Size 0x%x\r\n", 
							i, PIPE_TYPE_STRINGS[pPipe[i].PipeType],(pPipe[i].EndpointAddress & 0x0F),
							PIPE_DIRECTION[(pPipe[i].EndpointAddress >> 7)],pPipe[i].MaximumPacketSize);
						sStatus += sTemp;
					}
					pWnd->SetWindowText(sStatus);
				}

				if( hDevice != NULL)
					CloseHandle (hDevice); // Close the handle
			}
		}
	}
	ConfigureDialog( bResult && bN2pkVnaFound );
	if( bResult )
	{
		switch( nInterfaceType )
		{
		case INTERFACE_N2PK:
			if( bN2pkVnaFound )
				sTemp.LoadString( IDS_N2PK_FOUND );
			else
				sTemp.LoadString( IDS_DEVICE_NOTFOUND );
			break;
		case INTERFACE_HPIB:
			if( bN2pkVnaFound )
				sTemp.LoadString( IDS_HPIB_FOUND );
			else
				sTemp.LoadString( IDS_DEVICE_NOTFOUND );
			break;
		case INTERFACE_MSA:
			if( bN2pkVnaFound )
				sTemp.LoadString( IDS_MSA_FOUND );
			else
				sTemp.LoadString( IDS_DEVICE_NOTFOUND );
			break;
		default:
			sTemp = "";
		}
		sStatus += sTemp;
		pWnd->SetWindowText(sStatus);
	}
	else
	{
		sTemp.LoadString( IDS_NOTHING_FOUND );
		sStatus += sTemp;
		pWnd->SetWindowText(sStatus);
	}
}


void CCommunicate::ConfigureDialog( bool bState)
{
	CWnd *pWnd = GetDlgItem( IDC_BUTTON_READ );
	ASSERT_VALID(pWnd);
	pWnd->EnableWindow( bState );

	pWnd = GetDlgItem( IDC_BUTTON_WRITE );
	ASSERT_VALID(pWnd);
	pWnd->EnableWindow( bState );
	
	pWnd = GetDlgItem( IDC_BUTTON_BUILD_RAW );
	ASSERT_VALID(pWnd);
	pWnd->EnableWindow( bState );
	
	pWnd = GetDlgItem( IDC_BUTTON_BUILD_SET );
	ASSERT_VALID(pWnd);
	pWnd->EnableWindow( bState && (nInterfaceType == INTERFACE_N2PK));
	
	pWnd = GetDlgItem(IDC_EDIT_READ);
	ASSERT_VALID(pWnd);
	pWnd->SetWindowText("");
}


void CCommunicate::OnButtonWrite() 
{
	char buffer[256], *pStr, c1, c2;
	long nBytes;
	HANDLE hDevice;
	CString sStatus;
	BULK_TRANSFER_CONTROL bulkControl;
	bool bResult = false;
	CString sNew, sTemp;
//	CException ex;
	unsigned char BinaryData[256];

	CEdit* pWnd = (CEdit *)GetDlgItem(IDC_EDIT_WRITE);
	ASSERT_VALID(pWnd);
	pWnd->GetWindowText( buffer, sizeof(buffer));

	_strupr_s( buffer, sizeof( buffer) );
	pStr = buffer;

	int nByteCount = 0;
	while( *pStr != '\0' )
	{
		if( isxdigit( *pStr ))
		{
			if( isxdigit( *(pStr+1) ))
			{
				sNew += *pStr;
				sNew += *(pStr+1);
				sNew += ' ';
				c1 = *pStr;
				c2 = *(pStr+1);
				c1 -= '0';
				if( c1 > 9 ) 
					c1 -= ('A'-'0'-10);
				c2 -= '0';
				if( c2 > 9 ) 
					c2 -= ('A'-'0'-10);
				BinaryData[nByteCount] = (c1<<4)+c2;
				pStr += 2;
				nByteCount++;
			}
			else if( *(pStr+1) == ' ' || *(pStr+1) == '\0')
			{
				sNew += '0';
				sNew += *(pStr);
				sNew += ' ';
				c1 = *pStr;
				c1 -= '0';
				if( c1 > 9 ) 
					c1 -= ('A'-'0'-10);
				BinaryData[nByteCount] = c1;
				pStr++;
				nByteCount++;
			}
			// else error or eof
		}
		else if( *pStr == ' ')
			pStr++;
		else
		{
			AfxMessageBox( IDS_WRITE_DATA_ERROR, MB_OK );
			pWnd->SetFocus();
			return;
		}
	}
	pWnd->SetWindowText( sNew );

	pWnd = (CEdit *)GetDlgItem(IDC_EDIT_MESSAGES);
	ASSERT_VALID(pWnd);
	pWnd->FmtLines( true );

	if( nByteCount < 1 )
	{
		sStatus.LoadString( IDS_NOTHING_TO_WRITE );
		pWnd->SetWindowText(sStatus);
		hDevice = NULL;
		return;
	}
	else
	{
		sStatus.LoadString( IDS_WRITE_MESSAGE );
		sStatus += sNew;
		pWnd->SetWindowText(sStatus);
	}

	if( bUsingCyUSB )
	{
		bResult = USBDevice->Open( nCyUsbDevice );
		if( bResult )
		{
			nBytes = nByteCount;
			if( USBDevice->BulkOutEndPt )
				bResult = USBDevice->BulkOutEndPt->XferData( (PUCHAR)BinaryData, nBytes );
		}
	}
	else
	{
		if (bOpenDriver (&hDevice, (LPTSTR)(LPCTSTR)pcDriverName) != TRUE)
		{
			sTemp.LoadString( IDS_OPEN_DRIVER_FAIL );
			sStatus += "\r\n";
			sStatus += sTemp;
			pWnd->SetWindowText(sStatus);
			hDevice = NULL;
			return;
		}

		// TODO - Sort this out
		bulkControl.pipeNum = 0;

		if (hDevice != NULL) 
		{
			bResult = ( 0 != DeviceIoControl (hDevice,
							IOCTL_EZUSB_BULK_WRITE, 
							&bulkControl,
							sizeof (BULK_TRANSFER_CONTROL),
							BinaryData,
							nByteCount,
							(unsigned long *)&nBytes,
							NULL));
			CloseHandle (hDevice);
		}
	}
	if( bResult )
		sTemp.LoadString( IDS_WRITE_USB_OK );
	else
		sTemp.LoadString( IDS_WRITE_USB_ERROR );
	sStatus += "\r\n";
	sStatus += sTemp;
	pWnd->SetWindowText(sStatus);
}

void CCommunicate::OnButtonBuildRaw() 
{
	CBuildRaw rawDialog;
	int iResult;
	CString sTemp;

	iResult = rawDialog.DoModal();
	if( iResult == IDOK )
	{
		CEdit* pWnd = (CEdit *)GetDlgItem(IDC_EDIT_WRITE);
		ASSERT_VALID(pWnd);
		if( nInterfaceType == INTERFACE_MSA )
		{
			int nTempFlags = 0;
			if( RawMessage.flags & CmdVnaRawDataFlagsWriteA ) nTempFlags |= 1;
			if( RawMessage.flags & CmdVnaRawDataFlagsWriteB ) nTempFlags |= 2;
			if( RawMessage.flags & CmdVnaRawDataFlagsWriteC ) nTempFlags |= 4;
			if( RawMessage.flags & CmdVnaRawDataFlagsWriteD ) nTempFlags |= 8;
			if( RawMessage.flags & CmdVnaRawDataFlagsSetAtt ) nTempFlags |= 0x10;
			sTemp.Format("%02X %02X %02X %02X %02X %02X %02X", 
				0xA6,
				nTempFlags,
				RawMessage.portA,
				RawMessage.portB,
				RawMessage.portC,
				RawMessage.portD,
				RawMessage.attenuator ); // attenuator is port E !
		}
		else
			sTemp.Format("%02X %02X %02X %02X %02X %02X %02X %02X", 
				RawMessage.command_code,
				RawMessage.flags,
				RawMessage.portA,
				RawMessage.portB,
				RawMessage.attenuator,
				RawMessage.portD,
				RawMessage.Switch,
				RawMessage.portC );
		pWnd->SetWindowText( sTemp);
	}
}

void CCommunicate::OnButtonBuildSet() 
{
	CBuildSet setDialog;
	int iResult;
	CString sMessage, sTemp;
	int i;

	iResult = setDialog.DoModal();
	if( iResult == IDOK )
	{
		CEdit* pWnd = (CEdit *)GetDlgItem(IDC_EDIT_WRITE);
		ASSERT_VALID(pWnd);
		if( b_9912 )
		{
			sMessage.Format("%02X %02X %02X %02X %02X ", 
				SetMessage9912.command_code,
				SetMessage9912.flags,
				SetMessage9912.adc_delay,
				SetMessage9912.adc_reads,
				SetMessage9912.adc_mode
			);
			for(i=0;i<8;i++)
			{
				sTemp.Format( "%02X ", SetMessage9912.lo[i] & 0xff );
				sMessage += sTemp;
			}
			for(i=0;i<8;i++)
			{
				sTemp.Format( "%02X ", SetMessage9912.rf[i] & 0xff );
				sMessage += sTemp;
			}
		}
		else
		{
			sMessage.Format("%02X %02X %02X %02X %02X ", 
				SetMessage.command_code,
				SetMessage.flags,
				SetMessage.adc_delay,
				SetMessage.adc_reads,
				SetMessage.adc_mode
			);
			for(i=0;i<5;i++)
			{
				sTemp.Format( "%02X ", SetMessage.lo[i] & 0xff );
				sMessage += sTemp;
			}
			for(i=0;i<5;i++)
			{
				sTemp.Format( "%02X ", SetMessage.rf[i] & 0xff );
				sMessage += sTemp;
			}
		}
		pWnd->SetWindowText( sMessage );
	}
}
