// BuildRaw.cpp : implementation file
//
//(C) Copyright Dave Roberts G8KBB 2005
// This program is released only for the purpose of self training and eduation
// in amatuer radio. It may not be used for any commercial purpose, sold or
// modified.
// It has been written as an exercise in self tuition by me as part of my hobby
// and I make no claims about its fitness for purpose or correct operation.


#include "stdafx.h"
#include "usb configure.h"
#include "BuildRaw.h"
#include "common.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBuildRaw dialog


CBuildRaw::CBuildRaw(CWnd* pParent /*=NULL*/)
	: CDialog(CBuildRaw::IDD, pParent)
{
	//{{AFX_DATA_INIT(CBuildRaw)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CBuildRaw::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBuildRaw)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CBuildRaw, CDialog)
	//{{AFX_MSG_MAP(CBuildRaw)
	ON_BN_CLICKED(IDC_CHECKA, OnChecka)
	ON_BN_CLICKED(IDC_CHECKB, OnCheckb)
	ON_BN_CLICKED(IDC_CHECKC, OnCheckc)
	ON_BN_CLICKED(IDC_CHECKD, OnCheckd)
	ON_BN_CLICKED(IDC_CHECKATT, OnCheckatt)
	ON_EN_KILLFOCUS(IDC_EDIT_PORTA, OnKillfocusEditPorta)
	ON_EN_KILLFOCUS(IDC_EDIT_PORTB, OnKillfocusEditPortb)
	ON_EN_KILLFOCUS(IDC_EDIT_PORTC, OnKillfocusEditPortc)
	ON_EN_KILLFOCUS(IDC_EDIT_PORTD, OnKillfocusEditPortd)
	ON_EN_KILLFOCUS(IDC_EDIT_ATTEN, OnKillfocusEditAtten)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBuildRaw message handlers
//
// Set the displayed values to those currently held in RawMessage structure

BOOL CBuildRaw::OnInitDialog() 
{
	CDialog::OnInitDialog();
	CString sTemp;
	
	CWnd *pWnd = GetDlgItem( IDC_EDIT_PORTA );
	ASSERT_VALID(pWnd);
	sTemp.Format( "0x%02X", RawMessage.portA & 0xFF );
	pWnd->SetWindowText( sTemp );
	pWnd->EnableWindow( (RawMessage.flags & CmdVnaRawDataFlagsWriteA) != 0  );

	pWnd = GetDlgItem( IDC_EDIT_PORTB );
	ASSERT_VALID(pWnd);
	sTemp.Format( "0x%02X", RawMessage.portB & 0xFF );
	pWnd->SetWindowText( sTemp );
	pWnd->EnableWindow( (RawMessage.flags & CmdVnaRawDataFlagsWriteB) != 0  );

	pWnd = GetDlgItem( IDC_EDIT_PORTC );
	ASSERT_VALID(pWnd);
	sTemp.Format( "0x%02X", RawMessage.portC & 0xFF );
	pWnd->SetWindowText( sTemp );
	pWnd->EnableWindow( (RawMessage.flags & CmdVnaRawDataFlagsWriteC) != 0  );

	pWnd = GetDlgItem( IDC_EDIT_PORTD );
	ASSERT_VALID(pWnd);
	sTemp.Format( "0x%02X", RawMessage.portD & 0xFF );
	pWnd->SetWindowText( sTemp );
	pWnd->EnableWindow( (RawMessage.flags & CmdVnaRawDataFlagsWriteD) != 0  );

	switch( nInterfaceType )
	{
	case INTERFACE_MSA:
		sTemp.LoadStringA( IDS_SET_PORTE );
		break;
	case INTERFACE_N2PK:
	case INTERFACE_HPIB:
	default:
		sTemp.LoadStringA( IDS_SET_ATTENUATOR );
	}
	pWnd = GetDlgItem( IDC_CHECKATT );
	pWnd->SetWindowTextA( sTemp );

	pWnd = GetDlgItem( IDC_EDIT_ATTEN );
	ASSERT_VALID(pWnd);
	sTemp.Format( "0x%02X", RawMessage.attenuator & 0xFF );
	pWnd->SetWindowText( sTemp );
	pWnd->EnableWindow( (RawMessage.flags & CmdVnaRawDataFlagsSetAtt) != 0  );

	CButton *pButton = (CButton *)GetDlgItem( IDC_CHECKA );
	ASSERT_VALID(pButton);
	pButton->SetCheck( (RawMessage.flags & CmdVnaRawDataFlagsWriteA) != 0  );

	pButton = (CButton *)GetDlgItem( IDC_CHECKB );
	ASSERT_VALID(pButton);
	pButton->SetCheck( (RawMessage.flags & CmdVnaRawDataFlagsWriteB) != 0  );

	pButton = (CButton *)GetDlgItem( IDC_CHECKC );
	ASSERT_VALID(pButton);
	pButton->SetCheck( (RawMessage.flags & CmdVnaRawDataFlagsWriteC) != 0  );

	pButton = (CButton *)GetDlgItem( IDC_CHECKD );
	ASSERT_VALID(pButton);
	pButton->SetCheck( (RawMessage.flags & CmdVnaRawDataFlagsWriteD) != 0  );

	pButton = (CButton *)GetDlgItem( IDC_CHECKATT );
	ASSERT_VALID(pButton);
	pButton->SetCheck( (RawMessage.flags & CmdVnaRawDataFlagsSetAtt) != 0  );

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

/////////////////////////////////////////////////////////////////////////////
// OnCheck*
// for each of the values, these are the handler for when checkbox state changes
// Read state and set / clear corresponding flag in RawMessage flags and also
// enable / disable correspnding port value edit box

void CBuildRaw::OnChecka() 
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_CHECKA );
	ASSERT_VALID(pButton);
	int i = pButton->GetState() & 1;
	if( i )
		RawMessage.flags |= CmdVnaRawDataFlagsWriteA;
	else
		RawMessage.flags &= ~CmdVnaRawDataFlagsWriteA;

	CWnd *pWnd = GetDlgItem( IDC_EDIT_PORTA );
	ASSERT_VALID(pWnd);
	pWnd->EnableWindow( i );
}

void CBuildRaw::OnCheckb() 
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_CHECKB );
	ASSERT_VALID(pButton);
	int i = pButton->GetState() & 1;
	if( i )
		RawMessage.flags |= CmdVnaRawDataFlagsWriteB;
	else
		RawMessage.flags &= ~CmdVnaRawDataFlagsWriteB;

	CWnd *pWnd = GetDlgItem( IDC_EDIT_PORTB );
	ASSERT_VALID(pWnd);
	pWnd->EnableWindow( i );
}

void CBuildRaw::OnCheckc() 
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_CHECKC );
	ASSERT_VALID(pButton);
	int i = pButton->GetState() & 1;
	if( i )
		RawMessage.flags |= CmdVnaRawDataFlagsWriteC;
	else
		RawMessage.flags &= ~CmdVnaRawDataFlagsWriteC;

	CWnd *pWnd = GetDlgItem( IDC_EDIT_PORTC );
	ASSERT_VALID(pWnd);
	pWnd->EnableWindow( i );
}

void CBuildRaw::OnCheckd() 
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_CHECKD );
	ASSERT_VALID(pButton);
	int i = pButton->GetState() & 1;
	if( i )
		RawMessage.flags |= CmdVnaRawDataFlagsWriteD;
	else
		RawMessage.flags &= ~CmdVnaRawDataFlagsWriteD;

	CWnd *pWnd = GetDlgItem( IDC_EDIT_PORTD );
	ASSERT_VALID(pWnd);
	pWnd->EnableWindow( i );
}

void CBuildRaw::OnCheckatt() 
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_CHECKATT );
	ASSERT_VALID(pButton);
	int i = pButton->GetState() & 1;
	if( i )
		RawMessage.flags |= CmdVnaRawDataFlagsSetAtt;
	else
		RawMessage.flags &= ~CmdVnaRawDataFlagsSetAtt;

	CWnd *pWnd = GetDlgItem( IDC_EDIT_ATTEN );
	ASSERT_VALID(pWnd);
	pWnd->EnableWindow( i );
}

/////////////////////////////////////////////////////////////////////////////
// handlers for loss of focus from each edit control
//
// For each one, read edi box contents and convert to binary (hex OR decimal)
// then reformat as hex data item and update displayed value

void CBuildRaw::OnKillfocusEditPorta() 
{
	CString sTemp;
	char *szDummy;

	CWnd *pWnd = GetDlgItem( IDC_EDIT_PORTA );
	ASSERT_VALID(pWnd);
	pWnd->GetWindowText( sTemp );
	RawMessage.portA = (unsigned char)strtol( sTemp, &szDummy, 0 );
	sTemp.Format( "0x%02X", RawMessage.portA & 0xFF );
	pWnd->SetWindowText( sTemp );
}

void CBuildRaw::OnKillfocusEditPortb() 
{
	CString sTemp;
	char *szDummy;

	CWnd *pWnd = GetDlgItem( IDC_EDIT_PORTB );
	ASSERT_VALID(pWnd);
	pWnd->GetWindowText( sTemp );
	RawMessage.portB = (unsigned char)strtol( sTemp, &szDummy, 0 );
	sTemp.Format( "0x%02X", RawMessage.portB & 0xFF );
	pWnd->SetWindowText( sTemp );
}

void CBuildRaw::OnKillfocusEditPortc() 
{
	CString sTemp;
	char *szDummy;

	CWnd *pWnd = GetDlgItem( IDC_EDIT_PORTC );
	ASSERT_VALID(pWnd);
	pWnd->GetWindowText( sTemp );
	RawMessage.portC = (unsigned char)strtol( sTemp, &szDummy, 0 );
	sTemp.Format( "0x%02X", RawMessage.portC & 0xFF );
	pWnd->SetWindowText( sTemp );
}

void CBuildRaw::OnKillfocusEditPortd() 
{
	CString sTemp;
	char *szDummy;

	CWnd *pWnd = GetDlgItem( IDC_EDIT_PORTD );
	ASSERT_VALID(pWnd);
	pWnd->GetWindowText( sTemp );
	RawMessage.portD = (unsigned char)strtol( sTemp, &szDummy, 0 );
	sTemp.Format( "0x%02X", RawMessage.portD & 0xFF );
	pWnd->SetWindowText( sTemp );
}

void CBuildRaw::OnKillfocusEditAtten() 
{
	CString sTemp;
	char *szDummy;

	CWnd *pWnd = GetDlgItem( IDC_EDIT_ATTEN );
	ASSERT_VALID(pWnd);
	pWnd->GetWindowText( sTemp );
	RawMessage.attenuator = (unsigned char)strtol( sTemp, &szDummy, 0 ) & 0xff;
	sTemp.Format( "0x%02X", RawMessage.attenuator & 0xFF );
	pWnd->SetWindowText( sTemp );
}
