#if !defined(AFX_COMMON_H__132F4D0D_7193_4BEE_BAEA_AFCFBC4BA81F__INCLUDED_)
#define AFX_COMMON_H__132F4D0D_7193_4BEE_BAEA_AFCFBC4BA81F__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
// Common.h : header file
//
#include "winioctl.h"

#include "ezusbsys.h"


////////////////////////////////////////////////////////////////////////////////
// main.h: Header file for IOCTL calls
// $Header: /USB/Util/EzMr/main.h 3     8/08/00 2:26p Tpm $
// Copyright (c) 2000 Cypress Semiconductor. May not be reproduced without permission.
// See the EzUsb Developer's Kit license agreement for more details.
////////////////////////////////////////////////////////////////////////////////

#define MAX_DRIVER_NAME 64
#define DEVICE_DESCRIPTOR_SIZE 32 /* bigger than we need */
#define MAX_ITEMS_IN_LB 256
#define MAX_BUFFER_SIZE 512


#define GET_CONFIG_DESCRIPTOR_LENGTH(pv) \
    ((pUsb_Configuration_Descriptor)pv)->wTotalLength

typedef struct __usb_Dev_Descriptor__ {
    UCHAR bLength;
    UCHAR bDescriptorType;
    USHORT bcdUSB;
    UCHAR bDeviceClass;
    UCHAR bDeviceSubClass;
    UCHAR bDeviceProtocol;
    UCHAR bMaxPacketSize0;
    USHORT idVendor;
    USHORT idProduct;
    USHORT bcdDevice;
    UCHAR iManufacturer;
    UCHAR iProduct;
    UCHAR iSerialNumber;
    UCHAR bNumConfigurations;
} Usb_Device_Descriptor, *pUsb_Device_Descriptor;

typedef struct __usb_Config_Descriptor__ {
    UCHAR bLength;
    UCHAR bDescriptorType;
    USHORT wTotalLength;
    UCHAR bNumInterfaces;
    UCHAR bConfigurationValue;
    UCHAR iConfiguration;
    UCHAR bmAttributes;
    UCHAR MaxPower;
} Usb_Configuration_Descriptor, *pUsb_Configuration_Descriptor;

typedef struct __usb_String_Descriptor__ { //TPM added the usb_String_Descriptor
    UCHAR bLength;
    UCHAR bDescriptorType;
    WCHAR bString[1];
} Usb_String_Descriptor, *pUsb_String_Descriptor;

#define GET_STRING_DESCRIPTOR_LENGTH(pv) \
    ((pUsb_String_Descriptor)pv)->bLength

/*
typedef struct _USB_INTERFACE_DESCRIPTOR {
    UCHAR bLength;
    UCHAR bDescriptorType;
    UCHAR bInterfaceNumber;
    UCHAR bAlternateSetting;
    UCHAR bNumEndpoints;
    UCHAR bInterfaceClass;
    UCHAR bInterfaceSubClass;
    UCHAR bInterfaceProtocol;
    UCHAR iInterface;
} Usb_Interface_Descriptor, *pUsb_Interface_Descriptor;

typedef struct _USB_ENDPOINT_DESCRIPTOR {
    UCHAR bLength;
    UCHAR bDescriptorType;
    UCHAR bEndpointAddress;
    UCHAR bmAttributes;
    USHORT wMaxPacketSize;
    UCHAR bInterval;
} Usb_Endpoint_Descriptor, *pUsb_Endpoint_Descriptor;
*/

void
ParseDeviceDescriptor(PVOID pvBuffer, HWND hOutputBox);

void
ParseConfigurationDescriptor(PVOID pvBuffer, HWND hOutputBox);

//void
//DumpBuffer(PVOID pvBuffer, ULONG length, HWND hOutputBox);

typedef PVOID USBD_PIPE_HANDLE;
typedef PVOID USBD_CONFIGURATION_HANDLE;
typedef PVOID USBD_INTERFACE_HANDLE;

typedef enum _USBD_PIPE_TYPE {
    UsbdPipeTypeControl,
    UsbdPipeTypeIsochronous,
    UsbdPipeTypeBulk,
    UsbdPipeTypeInterrupt
} USBD_PIPE_TYPE;

typedef struct _USBD_PIPE_INFORMATION {
    //
    // OUTPUT
    // These fields are filled in by USBD
    //
    USHORT MaximumPacketSize;  // Maximum packet size for this pipe
    UCHAR EndpointAddress;     // 8 bit USB endpoint address (includes direction)
                               // taken from endpoint descriptor
    UCHAR Interval;            // Polling interval in ms if interrupt pipe 
    
    USBD_PIPE_TYPE PipeType;   // PipeType identifies type of transfer valid for this pipe
    USBD_PIPE_HANDLE PipeHandle;
    
    //
    // INPUT
    // These fields are filled in by the client driver
    //
    ULONG MaximumTransferSize; // Maximum size for a single request
                               // in bytes.
    ULONG PipeFlags;                                   
} USBD_PIPE_INFORMATION, *PUSBD_PIPE_INFORMATION;


typedef struct _USBD_INTERFACE_INFORMATION {
    USHORT Length;       // Length of this structure, including
                         // all pipe information structures that
                         // follow.
    //
    // INPUT
    //
    // Interface number and Alternate setting this
    // structure is associated with
    //
    UCHAR InterfaceNumber;
    UCHAR AlternateSetting;
    
    //
    // OUTPUT
    // These fields are filled in by USBD
    //
    UCHAR Class;
    UCHAR SubClass;
    UCHAR Protocol;
    UCHAR Reserved;
    
    USBD_INTERFACE_HANDLE InterfaceHandle;
    ULONG NumberOfPipes; 

    //
    // INPUT/OUPUT
    // see PIPE_INFORMATION
//TPM    USBD_PIPE_INFORMATION Pipes[0];
    USBD_PIPE_INFORMATION Pipes[1];

} USBD_INTERFACE_INFORMATION, *PUSBD_INTERFACE_INFORMATION;

typedef LONG USBD_STATUS;

typedef struct _USBD_ISO_PACKET_DESCRIPTOR {
    ULONG Offset;       // INPUT Offset of the packet from the begining of the
                        // buffer.

    ULONG Length;       // OUTPUT length of data received (for in).
                        // OUTPUT 0 for OUT.
    USBD_STATUS Status; // status code for this packet.     
} USBD_ISO_PACKET_DESCRIPTOR, *PUSBD_ISO_PACKET_DESCRIPTOR;


#define TGT_IMG_SIZE 0x10000 //64KB (65,536 Byte) target image
#define TGT_SEG_SIZE 16		//16 byte segments

struct MemSeg
{
	DWORD TAddr; //Target Address
	DWORD HAddr; //Host Address
	DWORD Size;  //block size
	DWORD Stat;  //status
	PCHAR pData; //data bytes
};

struct TMemImg
{
	CHAR data[TGT_IMG_SIZE]; //target image store
};

struct TMemCache
{
	TMemImg* pImg;	//pointer to image
	int nSeg;		//segment count
	MemSeg pSeg[TGT_IMG_SIZE/TGT_SEG_SIZE]; //info about segments
	unsigned nTotalBytes;
};

#define MAX_EP0_XFER_SIZE (1024*4) // 4K Control EP0 transfer limit imposed by OS 

bool bOpenDriver (HANDLE * phDeviceHandle, PCHAR devname);

int DownloadFile( CEdit *pWnd, CString m_LogFilename );
int Reset8051( bool bHold, HANDLE hDevice );
int intel_in(FILE *fpIn, TMemCache* pMemCache, DWORD &ioOffset, 
						char endianFlags, BOOLEAN spaces);
int DumpBuffer(char *buffer,int nBytes,CString *sData);
bool GetStringDescriptor( HANDLE hDevice, GET_STRING_DESCRIPTOR_IN *input, CString *sOutput );

// {AE18AA60-7F6A-11d4-97DD-00010229B959}
//static GUID CYUSBDRV_GUID = {0xae18aa60, 0x7f6a, 0x11d4, 0x97, 0xdd, 0x0, 0x1, 0x2, 0x29, 0xb9, 0x59};

// {C63859BD-5C4B-474d-9572-CE604E611D73}
static const GUID N2PK_USB_GUID  = 
{ 0xc63859bd, 0x5c4b, 0x474d, { 0x95, 0x72, 0xce, 0x60, 0x4e, 0x61, 0x1d, 0x73 } };

// {A8C2BDB4-97EA-4711-BD4C-0453585BB290}
static const GUID MSA_USB_GUID = 
{ 0xa8c2bdb4, 0x97ea, 0x4711, { 0xbd, 0x4c, 0x4, 0x53, 0x58, 0x5b, 0xb2, 0x90 } };

extern CCyUSBDevice *USBDevice;
extern CCyUSBDevice *USBDeviceN2PK;
extern CCyUSBDevice *USBDeviceCyUSB;
extern CCyUSBDevice *USBDeviceMSA;
extern bool bUsingCyUSB;
extern int nCyUsbDevices, nN2pkUsbDevices, nMsaUsbDevices;
extern int b_9912;

#define INTERFACE_N2PK 0
#define INTERFACE_HPIB 1
#define INTERFACE_MSA 2
extern int nInterfaceType;

extern int nCyUsbDevice;
extern bool bUsingN2pkGUID;
extern bool bSupport9912;
extern bool bUsingMsaGUID;

#define BASE_EZUSB_NAME "ezusb-0"
#define BASE_CYUSB_N2PK_NAME "N2PK USB device "
#define BASE_CYUSB_NAME "cyUSB device "
#define BASE_CYUSB_MSA_NAME "MSA USB device "
#endif
