// FindDevices.cpp : implementation file
//
//(C) Copyright Dave Roberts G8KBB 2005
// This program is released only for the purpose of self training and eduation
// in amatuer radio. It may not be used for any commercial purpose, sold or
// modified.
// It has been written as an exercise in self tuition by me as part of my hobby
// and I make no claims about its fitness for purpose or correct operation.


#include "stdafx.h"
#include "usb configure.h"
#include "FindDevices.h"
#include "common.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFindDevices dialog


CFindDevices::CFindDevices(CWnd* pParent /*=NULL*/)
	: CDialog(CFindDevices::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFindDevices)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CFindDevices::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFindDevices)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFindDevices, CDialog)
	//{{AFX_MSG_MAP(CFindDevices)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFindDevices message handlers

// **************************************************************************
// On statup get the current device driver name and try all variants on it.
// A variant is a name where the last character (assumed to be a digit) can
// take any value from 0 to 9, so try openin comms for all 10 such filenames
// For every one that works, add its name to the drop down listbox so the 
// user can choose.

BOOL CFindDevices::OnInitDialog() 
{
	CDialog::OnInitDialog();
	CString sTemp, sTemp2, sTemp3;
	HANDLE hDevice;
	bool bResult;
	nCyUsbDevices = 0;

	CComboBox *pWnd = (CComboBox *)GetDlgItem(IDC_COMBO_DEVICES);
	ASSERT_VALID(pWnd);
	pWnd->SendMessage(CB_RESETCONTENT, 0, 0);

	sTemp = BASE_CYUSB_NAME;
	int i = sTemp.GetLength();
	nCyUsbDevices = USBDeviceCyUSB->DeviceCount();
	if ( nCyUsbDevices > 0 )
	{
		for(int j=0;j<nCyUsbDevices;j++)
		{
			bResult = USBDeviceCyUSB->Open(j);
			if( bResult )
			{
				sTemp2 = sTemp;
				sTemp3.Format("%d", j);
				sTemp2 += sTemp3;
				pWnd->SendMessage(CB_ADDSTRING, 0, (LPARAM)(LPCTSTR)sTemp2);
			}
		}	
	} 
	sTemp = BASE_CYUSB_N2PK_NAME;
	i = sTemp.GetLength();
	nN2pkUsbDevices = USBDeviceN2PK->DeviceCount();
	if ( nN2pkUsbDevices > 0 )
	{
		for(int j=0;j<nN2pkUsbDevices;j++)
		{
			bResult = USBDeviceN2PK->Open(j);
			if( bResult )
			{
				sTemp2 = sTemp;
				sTemp3.Format("%d", j);
				sTemp2 += sTemp3;
				pWnd->SendMessage(CB_ADDSTRING, 0, (LPARAM)(LPCTSTR)sTemp2);
			}
		}	
	} 

	sTemp = BASE_CYUSB_MSA_NAME;
	i = sTemp.GetLength();
	nMsaUsbDevices = USBDeviceMSA->DeviceCount();
	if ( nMsaUsbDevices > 0 )
	{
		for(int j=0;j<nMsaUsbDevices;j++)
		{
			bResult = USBDeviceMSA->Open(j);
			if( bResult )
			{
				sTemp2 = sTemp;
				sTemp3.Format("%d", j);
				sTemp2 += sTemp3;
				pWnd->SendMessage(CB_ADDSTRING, 0, (LPARAM)(LPCTSTR)sTemp2);
			}
		}	
	} 

	sTemp = BASE_EZUSB_NAME;
	sTemp.TrimLeft();
	sTemp.TrimRight();
	i = sTemp.GetLength();
	if(i>=2)
		for(char j='0';j<='9';j++)
		{
			sTemp2 = sTemp.Left(i-1);
			sTemp2 += j;
			bResult = bOpenDriver (&hDevice, (LPTSTR)(LPCTSTR)sTemp2);
			if( bResult )
			{
				pWnd->SendMessage(CB_ADDSTRING, 0, (LPARAM)(LPCTSTR)sTemp2);
				CloseHandle (hDevice);
			}
		}
	pWnd->SendMessage(CB_SETCURSEL, 0, 0);


	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

// **************************************************************************
// The clicked OK so we need to update the current stored filename with the
// new selection.

void CFindDevices::OnOK() 
{
	CComboBox *pWnd = (CComboBox *)GetDlgItem(IDC_COMBO_DEVICES);
	ASSERT_VALID(pWnd);
	int i = pWnd->GetCurSel();
	if( i != CB_ERR )
	{
		if( i < nCyUsbDevices )
		{
			nCyUsbDevice = i;
			bUsingCyUSB = true;
			bUsingMsaGUID = false;
			bUsingN2pkGUID = false;
			USBDevice = USBDeviceCyUSB;
		}
		else if( i < nCyUsbDevices + nN2pkUsbDevices )
		{
			nCyUsbDevice = i - nCyUsbDevices;
			bUsingCyUSB = true;
			bUsingMsaGUID = false;
			bUsingN2pkGUID = true;
			USBDevice = USBDeviceN2PK;
		}
		else if( i < nCyUsbDevices + nN2pkUsbDevices + nMsaUsbDevices)
		{
			nCyUsbDevice = i - nCyUsbDevices- nN2pkUsbDevices;
			bUsingCyUSB = true;
			bUsingN2pkGUID = false;
			bUsingMsaGUID = true;
			USBDevice = USBDeviceMSA;
		}
		else
			bUsingCyUSB = false;
		pWnd->GetLBText( i, pcDriverName );
	}


	CDialog::OnOK();
}
