// BuildSet.cpp : implementation file
//
//(C) Copyright Dave Roberts G8KBB 2005
// This program is released only for the purpose of self training and eduation
// in amatuer radio. It may not be used for any commercial purpose, sold or
// modified.
// It has been written as an exercise in self tuition by me as part of my hobby
// and I make no claims about its fitness for purpose or correct operation.


#include "stdafx.h"
#include "usb configure.h"
#include "BuildSet.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern int b_9912;

/////////////////////////////////////////////////////////////////////////////
// CBuildSet dialog


CBuildSet::CBuildSet(CWnd* pParent /*=NULL*/)
	: CDialog(CBuildSet::IDD, pParent)
{
	//{{AFX_DATA_INIT(CBuildSet)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CBuildSet::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBuildSet)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CBuildSet, CDialog)
	//{{AFX_MSG_MAP(CBuildSet)
	ON_BN_CLICKED(IDC_CHECK_DDS_RESET, OnCheckDdsReset)
	ON_BN_CLICKED(IDC_CHECK_DDS_SET, OnCheckDdsSet)
	ON_BN_CLICKED(IDC_CHECK_DELAY_USEC, OnCheckDelayUsec)
	ON_BN_CLICKED(IDC_CHECK_PAUSE_IN, OnCheckPauseIn)
	ON_BN_CLICKED(IDC_CHECK_PAUSE_OUT, OnCheckPauseOut)
	ON_CBN_SELCHANGE(IDC_COMBO_COUNT, OnSelchangeComboCount)
	ON_EN_KILLFOCUS(IDC_EDIT_DELAY, OnKillfocusEditDelay)
	ON_EN_KILLFOCUS(IDC_EDIT_MODE, OnKillfocusEditMode)
	ON_EN_KILLFOCUS(IDC_EDIT_RFDDS, OnKillfocusEditRfdds)
	ON_EN_KILLFOCUS(IDC_EDIT_LODDS, OnKillfocusEditLodds)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBuildSet message handlers
//
// on initalise dialod
// Set the displayed values to those currently held in SetMessage structure


BOOL CBuildSet::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	CString sTemp;
	int i;
	
	CButton *pButton = (CButton *)GetDlgItem( IDC_CHECK_DDS_RESET );
	ASSERT_VALID(pButton);
	pButton->SetCheck( (SetMessage.flags & bCmdVnaSetDdsFlagsReset) != 0  );

	pButton = (CButton *)GetDlgItem( IDC_CHECK_DDS_SET );
	ASSERT_VALID(pButton);
	pButton->SetCheck( (SetMessage.flags & bCmdVnaSetDdsFlagsDdsSet) != 0  );
	
	pButton = (CButton *)GetDlgItem( IDC_CHECK_DELAY_USEC );
	ASSERT_VALID(pButton);
	pButton->SetCheck( (SetMessage.flags & bCmdVnaSetDdsFlagsDelayIsUsec) != 0  );
	
	pButton = (CButton *)GetDlgItem( IDC_CHECK_PAUSE_IN );
	ASSERT_VALID(pButton);
	pButton->SetCheck( (SetMessage.flags & bCmdVnaSetDdsFlagsPauseDataIn) != 0  );
	
	pButton = (CButton *)GetDlgItem( IDC_CHECK_PAUSE_OUT );
	ASSERT_VALID(pButton);
	pButton->SetCheck( (SetMessage.flags & bCmdVnaSetDdsFlagsPauseDataOut) != 0  );
	
	CComboBox *pCombo = (CComboBox *)GetDlgItem( IDC_COMBO_COUNT );
	ASSERT_VALID(pCombo);
	pCombo->ResetContent();
	for( i=0; i<31; i++)
	{
		sTemp.Format("%d",i);
		pCombo->AddString( sTemp );
	}
	if( SetMessage.adc_reads > 30 )
		SetMessage.adc_reads = 30;
	pCombo->SetCurSel( SetMessage.adc_reads );

	CWnd *pWnd = GetDlgItem( IDC_EDIT_DELAY );
	ASSERT_VALID(pWnd);
	sTemp.Format( "0x%02X", SetMessage.adc_delay & 0xFF );
	pWnd->SetWindowText( sTemp );

	pWnd = GetDlgItem( IDC_EDIT_MODE );
	ASSERT_VALID(pWnd);
	sTemp.Format( "0x%02X", SetMessage.adc_mode & 0xFF );
	pWnd->SetWindowText( sTemp );

	pWnd = GetDlgItem( IDC_EDIT_RFDDS );
	ASSERT_VALID(pWnd);
	if( b_9912 )
	{
		sTemp.Format( "%02X %02X %02X %02X %02X %02X %02X %02X ", 
			SetMessage9912.rf[0] & 0xFF,
			SetMessage9912.rf[1] & 0xFF,
			SetMessage9912.rf[2] & 0xFF,
			SetMessage9912.rf[3] & 0xFF,
			SetMessage9912.rf[4] & 0xFF,
			SetMessage9912.rf[5] & 0xFF,
			SetMessage9912.rf[6] & 0xFF,
			SetMessage9912.rf[7] & 0xFF
			);
		pWnd->SetWindowText( sTemp );

		pWnd = GetDlgItem( IDC_EDIT_LODDS );
		ASSERT_VALID(pWnd);
		sTemp.Format( "%02X %02X %02X %02X %02X %02X %02X %02X ", 
			SetMessage9912.lo[0] & 0xFF,
			SetMessage9912.lo[1] & 0xFF,
			SetMessage9912.lo[2] & 0xFF,
			SetMessage9912.lo[3] & 0xFF,
			SetMessage9912.lo[4] & 0xFF,
			SetMessage9912.lo[5] & 0xFF,
			SetMessage9912.lo[6] & 0xFF,
			SetMessage9912.lo[7] & 0xFF
			);
	}
	else
	{
		sTemp.Format( "%02X %02X %02X %02X %02X ", 
			SetMessage.rf[0] & 0xFF,
			SetMessage.rf[1] & 0xFF,
			SetMessage.rf[2] & 0xFF,
			SetMessage.rf[3] & 0xFF,
			SetMessage.rf[4] & 0xFF
			);
		pWnd->SetWindowText( sTemp );

		pWnd = GetDlgItem( IDC_EDIT_LODDS );
		ASSERT_VALID(pWnd);
		sTemp.Format( "%02X %02X %02X %02X %02X ", 
			SetMessage.lo[0] & 0xFF,
			SetMessage.lo[1] & 0xFF,
			SetMessage.lo[2] & 0xFF,
			SetMessage.lo[3] & 0xFF,
			SetMessage.lo[4] & 0xFF
			);
	}
	pWnd->SetWindowText( sTemp );

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

/////////////////////////////////////////////////////////////////////////////
// OnCheck*
// for each of the values, these are the handler for when checkbox state changes
// Read state and set / clear corresponding flag in RawMessage flags and also
// enable / disable correspnding port value edit box where appropriate

void CBuildSet::OnCheckDdsReset() 
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_CHECK_DDS_RESET );
	ASSERT_VALID(pButton);
	int i = pButton->GetState() & 1;
	if( i )
		SetMessage.flags |= bCmdVnaSetDdsFlagsReset;
	else
		SetMessage.flags &= ~bCmdVnaSetDdsFlagsReset;
	SetMessage9912.flags = SetMessage.flags;
}

void CBuildSet::OnCheckDdsSet() 
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_CHECK_DDS_SET );
	ASSERT_VALID(pButton);
	int i = pButton->GetState() & 1;
	if( i )
		SetMessage.flags |= bCmdVnaSetDdsFlagsDdsSet;
	else
		SetMessage.flags &= ~bCmdVnaSetDdsFlagsDdsSet;
	SetMessage9912.flags = SetMessage.flags;
}


void CBuildSet::OnCheckDelayUsec() 
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_CHECK_DELAY_USEC );
	ASSERT_VALID(pButton);
	int i = pButton->GetState() & 1;
	if( i )
		SetMessage.flags |= bCmdVnaSetDdsFlagsDelayIsUsec;
	else
		SetMessage.flags &= ~bCmdVnaSetDdsFlagsDelayIsUsec;
	SetMessage9912.flags = SetMessage.flags;
}

void CBuildSet::OnCheckPauseIn() 
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_CHECK_PAUSE_IN );
	ASSERT_VALID(pButton);
	int i = pButton->GetState() & 1;
	if( i )
		SetMessage.flags |= bCmdVnaSetDdsFlagsPauseDataIn;
	else
		SetMessage.flags &= ~bCmdVnaSetDdsFlagsPauseDataIn;
	SetMessage9912.flags = SetMessage.flags;
}

void CBuildSet::OnCheckPauseOut() 
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_CHECK_PAUSE_OUT );
	ASSERT_VALID(pButton);
	int i = pButton->GetState() & 1;
	if( i )
		SetMessage.flags |= bCmdVnaSetDdsFlagsPauseDataOut;
	else
		SetMessage.flags &= ~bCmdVnaSetDdsFlagsPauseDataOut;
	SetMessage9912.flags = SetMessage.flags;
}

/////////////////////////////////////////////////////////////////////////////
// ADC count handler. Find the current index (index 0 = 0 reads etc)
// and store value

void CBuildSet::OnSelchangeComboCount() 
{
	CComboBox *pCombo = (CComboBox *)GetDlgItem( IDC_COMBO_COUNT );
	ASSERT_VALID(pCombo);
	SetMessage.adc_reads = pCombo->GetCurSel();
	SetMessage9912.adc_reads = SetMessage.adc_reads;
}

/////////////////////////////////////////////////////////////////////////////
// handlers for loss of focus from each edit control
//
// For each one, read edit box contents and convert to binary (hex OR decimal)
// then reformat as hex data item and update displayed value
// NOTE RF and LO DDS are a bit more complex as 5 bytes are needed

void CBuildSet::OnKillfocusEditDelay() 
{
	CString sTemp;
	char *szDummy;

	CWnd *pWnd = GetDlgItem( IDC_EDIT_DELAY );
	ASSERT_VALID(pWnd);
	pWnd->GetWindowText( sTemp );
	SetMessage.adc_delay = (unsigned char)strtol( sTemp, &szDummy, 0 );
	SetMessage9912.adc_delay = SetMessage.adc_delay;
	sTemp.Format( "0x%02X", SetMessage.adc_delay & 0xFF );
	pWnd->SetWindowText( sTemp );
}

void CBuildSet::OnKillfocusEditMode() 
{
	CString sTemp;
	char *szDummy;

	CWnd *pWnd = GetDlgItem( IDC_EDIT_MODE );
	ASSERT_VALID(pWnd);
	pWnd->GetWindowText( sTemp );
	SetMessage.adc_mode = (unsigned char)strtol( sTemp, &szDummy, 0 );
	SetMessage9912.adc_mode = SetMessage.adc_mode;
	sTemp.Format( "0x%02X", SetMessage.adc_mode & 0xFF );
	pWnd->SetWindowText( sTemp );
}

void CBuildSet::OnKillfocusEditRfdds() 
{
	char *pStr;
	CString sNew;
	char c1, c2;
//	CException ex;
	char buffer[128];

	CEdit* pWnd = (CEdit *)GetDlgItem(IDC_EDIT_RFDDS);
	ASSERT_VALID(pWnd);
	pWnd->GetWindowText( buffer, sizeof(buffer));

	pStr = buffer;

	int nByteCount = 0;
	while( *pStr != '\0' && nByteCount < (b_9912 ? 8 : 5) )
	{
		if( isxdigit( *pStr ))
		{
			if( isxdigit( *(pStr+1) ))
			{
				sNew += *pStr;
				sNew += *(pStr+1);
				sNew += ' ';
				c1 = *pStr;
				c2 = *(pStr+1);
				c1 -= '0';
				if( c1 > 9 ) 
					c1 -= ('A'-'0'-10);
				c2 -= '0';
				if( c2 > 9 ) 
					c2 -= ('A'-'0'-10);
				if( b_9912 )
					SetMessage9912.rf[nByteCount] = (c1<<4)+c2;
				else
					SetMessage.rf[nByteCount] = (c1<<4)+c2;
				pStr += 2;
				nByteCount++;
			}
			else if( *(pStr+1) == ' ' || *(pStr+1) == '\0')
			{
				sNew += '0';
				sNew += *(pStr);
				sNew += ' ';
				c1 = *pStr;
				c1 -= '0';
				if( c1 > 9 ) 
					c1 -= ('A'-'0'-10);
				if( b_9912 )
					SetMessage9912.rf[nByteCount] = c1;
				else
					SetMessage.rf[nByteCount] = c1;
				pStr++;
				nByteCount++;
			}
			// else error or eof
		}
		else if( *pStr == ' ')
			pStr++;
		else
		{
			AfxMessageBox( IDS_WRITE_DATA_ERROR,MB_OK );
			pWnd->SetFocus();
			return;
		}
	}
	if( b_9912 )
	{
		while( nByteCount < 8 )
		{
			sNew += "00 ";
			SetMessage9912.rf[nByteCount] = 0;
			nByteCount++;
		}
	}
	else
	{
		while( nByteCount < 5 )
		{
			sNew += "00 ";
			SetMessage.rf[nByteCount] = 0;
			nByteCount++;
		}
	}
	pWnd->SetWindowText( sNew );
	
}


void CBuildSet::OnKillfocusEditLodds() 
{
	char *pStr;
	CString sNew;
	char c1, c2;
//	CException ex;
	char buffer[128];

	CEdit* pWnd = (CEdit *)GetDlgItem(IDC_EDIT_LODDS);
	ASSERT_VALID(pWnd);
	pWnd->GetWindowText( buffer, sizeof(buffer));

	pStr = buffer;

	int nByteCount = 0;
	while( *pStr != '\0' && nByteCount <  (b_9912 ? 8 : 5) )
	{
		if( isxdigit( *pStr ))
		{
			if( isxdigit( *(pStr+1) ))
			{
				sNew += *pStr;
				sNew += *(pStr+1);
				sNew += ' ';
				c1 = *pStr;
				c2 = *(pStr+1);
				c1 -= '0';
				if( c1 > 9 ) 
					c1 -= ('A'-'0'-10);
				c2 -= '0';
				if( c2 > 9 ) 
					c2 -= ('A'-'0'-10);
				if( b_9912 )
					SetMessage9912.lo[nByteCount] = (c1<<4)+c2;
				else
					SetMessage.lo[nByteCount] = (c1<<4)+c2;
				pStr += 2;
				nByteCount++;
			}
			else if( *(pStr+1) == ' ' || *(pStr+1) == '\0')
			{
				sNew += '0';
				sNew += *(pStr);
				sNew += ' ';
				c1 = *pStr;
				c1 -= '0';
				if( c1 > 9 ) 
					c1 -= ('A'-'0'-10);
				if( b_9912 )
					SetMessage9912.lo[nByteCount] = c1;
				else
					SetMessage.lo[nByteCount] = c1;
				pStr++;
				nByteCount++;
			}
			// else error or eof
		}
		else if( *pStr == ' ')
			pStr++;
		else
		{
			AfxMessageBox( IDS_WRITE_DATA_ERROR, MB_OK );
			pWnd->SetFocus();
			return;
		}
	}
	if( b_9912 )
	{
		while( nByteCount < 8 )
		{
			sNew += "00 ";
			SetMessage9912.lo[nByteCount] = 0;
			nByteCount++;
		}
	}
	else
	{
		while( nByteCount < 5 )
		{
			sNew += "00 ";
			SetMessage.lo[nByteCount] = 0;
			nByteCount++;
		}
	}
	pWnd->SetWindowText( sNew );
	
	
}
