#if !defined(AFX_SETUP_H__28FCAF09_6CC1_4B74_9215_222D31072755__INCLUDED_)
#define AFX_SETUP_H__28FCAF09_6CC1_4B74_9215_222D31072755__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
// setup.h : header file
//
//(C) Copyright Dave Roberts G8KBB 2005
// This program is released only for the purpose of self training and eduation
// in amatuer radio. It may not be used for any commercial purpose, sold or
// modified.
// It has been written as an exercise in self tuition by me as part of my hobby
// and I make no claims about its fitness for purpose or correct operation.

/////////////////////////////////////////////////////////////////////////////
// setup dialog

class setup : public CPropertyPage
{
	DECLARE_DYNCREATE(setup)

// Construction
public:
	setup();
	~setup();

// Dialog Data
	//{{AFX_DATA(setup)
	enum { IDD = IDD_NoiseMeter_DIALOG_SETUP };
	int		m_uWaveInDev;
	int		m_uWaveInFormat;
	//}}AFX_DATA

	int nSampleRate;
	int nBitsPerSample;
	int nMilliSeconds;
	bool bIsStereo;
	int nFFTBlockSize;
	bool bUseEnrFile;
	bool bUseLogFile;
	bool bUseHighPassFilter;
	CString m_LogFilename;
	CString m_UsbDeviceName;
	bool bEnableAutomation;
	double ComputeENR( double dEnrOrFrequency );
	void SwitchDevices( bool bNoise, bool bDut );
	int nAutomateDecimalPoints;


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(setup)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(setup)
	virtual BOOL OnInitDialog();
	afx_msg void OnSelendokWaveInDev();
	afx_msg void OnSelendokWaveInFormat();
	afx_msg void OnButtonSetupSave();
	afx_msg void OnSelendokComboTime();
	afx_msg void OnButtonFile();
	afx_msg void OnKillfocusEditConfigFilename();
	afx_msg void OnSelendokComboFftBlock();
	afx_msg void OnSelendokComboAuto();
	afx_msg void OnCheckUseEnrFile();
	afx_msg void OnSelendokComboNoise();
	afx_msg void OnButtonLogFile();
	afx_msg void OnKillfocusEditLogFilename();
	afx_msg void OnCheckLogResults();
	afx_msg void OnCheckHighPass();
	afx_msg void OnSelendokComboDut();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
protected:
	void PopulateCombo2();
	void PopulateComboNoiseDUT();
	int ReadValidEnrFile();
	int nAutomateNoiseSelection;
	int nAutomateDutSelection;
	CString szAutomateName;
   	CString m_Filename;
	HANDLE hAutomateDevice;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

// VC5 or 6 do not include definitions for 96 or 48 KHz. Include them if not defined

#ifndef WAVE_FORMAT_96M08

#define WAVE_FORMAT_48M08      0x00001000       /* 48     kHz, Mono,   8-bit  */
#define WAVE_FORMAT_48S08      0x00002000       /* 48     kHz, Stereo, 8-bit  */
#define WAVE_FORMAT_48M16      0x00004000       /* 48     kHz, Mono,   16-bit */
#define WAVE_FORMAT_48S16      0x00008000       /* 48     kHz, Stereo, 16-bit */
#define WAVE_FORMAT_96M08      0x00010000       /* 96     kHz, Mono,   8-bit  */
#define WAVE_FORMAT_96S08      0x00020000       /* 96     kHz, Stereo, 8-bit  */
#define WAVE_FORMAT_96M16      0x00040000       /* 96     kHz, Mono,   16-bit */
#define WAVE_FORMAT_96S16      0x00080000       /* 96     kHz, Stereo, 16-bit */

#endif

// useful definitions
// we need a max frequency - this is totally arbitrary
#define MAX_PERMITTED_FREQ_MHZ	30000
// ditto - we don't allow ENRs greater than 50 dB
#define MAX_PERMITTED_ENR_DB	50
// design decision - table max size until we give an error
#define CAL_TABLE_SIZE			1024
// if no registry value is found, start with this value
#define DEFAULT_FFT_BLOCK_SIZE	8192



#endif // !defined(AFX_SETUP_H__28FCAF09_6CC1_4B74_9215_222D31072755__INCLUDED_)
