#if !defined(AFX_DEVICENF_H__906400F1_0D0A_4EEF_A881_C27BC8AA11B9__INCLUDED_)
#define AFX_DEVICENF_H__906400F1_0D0A_4EEF_A881_C27BC8AA11B9__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
// deviceNF.h : header file
//
//(C) Copyright Dave Roberts G8KBB 2005
// This program is released only for the purpose of self training and eduation
// in amatuer radio. It may not be used for any commercial purpose, sold or
// modified.
// It has been written as an exercise in self tuition by me as part of my hobby
// and I make no claims about its fitness for purpose or correct operation.

/////////////////////////////////////////////////////////////////////////////
// deviceNF dialog

class deviceNF : public CPropertyPage
{
	DECLARE_DYNCREATE(deviceNF)

// Construction
public:
	deviceNF();
	~deviceNF();

// Dialog Data
	//{{AFX_DATA(deviceNF)
	enum { IDD = IDD_NoiseMeter_DIALOG_NF };
	//}}AFX_DATA

// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(deviceNF)
	public:
	virtual BOOL OnSetActive();
	virtual BOOL OnKillActive();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

public:
	// How many dummy reads before valid reads to allow settling time?
	int m_uDummyReads;
	double dEnrOrFrequency;
	double dT0;		// T0 reference temperature of 290

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(deviceNF)
	afx_msg void OnCheckNoiseSwitch();
	virtual BOOL OnInitDialog();
	afx_msg void OnCheckDutSwitch();
	afx_msg void OnButtonRefOn();
	afx_msg void OnButtonRefOff();
	afx_msg void OnButtonDeviceOn();
	afx_msg void OnButtonDeviceOff();
	afx_msg void OnChangeEditEnr();
	afx_msg void OnChangeEditTsoff();
	afx_msg void OnCheckAverage();
	afx_msg void OnSelendokComboAvgCount();
	afx_msg void OnButtonMeasureSave();
	afx_msg void OnCheckOverallNfMode();
	afx_msg void OnSelendokComboDummies();
	afx_msg void OnCheckRepeat();
	afx_msg void OnButtonClr();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
protected:
	void SetButtonConfig();
	bool DoReading( int WhichOne, int WhichDialog );
	void ShowResults();

	bool m_bNoiseSwitchAuto;
	bool m_bDutSwitchAuto;
	bool bMeasureRepeat;
	double dTSOff;
	double dEnr;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.


#endif // !defined(AFX_DEVICENF_H__906400F1_0D0A_4EEF_A881_C27BC8AA11B9__INCLUDED_)
