// NoiseMeter.h : main header file for the NoiseMeter application
//
//(C) Copyright Dave Roberts G8KBB 2005
// This program is released only for the purpose of self training and eduation
// in amatuer radio. It may not be used for any commercial purpose, sold or
// modified.
// It has been written as an exercise in self tuition by me as part of my hobby
// and I make no claims about its fitness for purpose or correct operation.

#if !defined(AFX_NoiseMeter_H__593FCAE9_2DA3_4ABF_93A3_3F2D217BFCA8__INCLUDED_)
#define AFX_NoiseMeter_H__593FCAE9_2DA3_4ABF_93A3_3F2D217BFCA8__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"		// main symbols
#include "NoiseMeterPropertySheet.h"

/////////////////////////////////////////////////////////////////////////////
// CNoiseMeterApp:
// See NoiseMeter.cpp for the implementation of this class
//


class CNoiseMeterApp : public CWinApp
{
public:
	CNoiseMeterApp();

private:
	CNoiseMeterPropertySheet dlg;


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CNoiseMeterApp)
	public:
	virtual BOOL InitInstance();
	virtual int ExitInstance();
	//}}AFX_VIRTUAL

// Implementation

	//{{AFX_MSG(CNoiseMeterApp)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};


/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#define MAX_AVERAGE	32
// this must be greater than the highest sampling rate for buffer allocation
#define MAX_ADC_SPEED 100000
// this must be equal to greatest sample time
#define MAX_TIME_MSEC 10000
// max buffer size needs to be product of:
//		speed, 
//		time, 
//		2 for stereo modes
//		and 1 for 8 but, 2 for 16 bit or 3 for 24 bit etc. 
#define MAX_DATA_BUFFER_SIZE (MAX_ADC_SPEED*MAX_TIME_MSEC/1000*2*3)
#define MAX_DUMMY_READS		10
#define GAIN_LIMIT_DB 50
#define T_LIMIT_K 300000
#define ENR_LIMIT_DB 50

#define DEFAULT_TSOFF "293.0"
#define DEFAULT_T0 "290.0"
#define DEFAULT_ENR "25.0"

#define BOLTZMANN ((double)1.380662e-23)

// useful macro in enabling controls
#define SET_STATE( control, condition ) { pWnd = GetDlgItem(control); ASSERT_VALID(pWnd); pWnd->EnableWindow( condition ); }
#define SET_READONLY( control, condition ) { pWnd = GetDlgItem(control); ASSERT_VALID(pWnd); 	pWnd->SendMessage(EM_SETREADONLY, (WPARAM)(condition), 0); }


// return value for signal out of range in NF measurement
#define IDERRORTOOHIGH	9999



#endif // !defined(AFX_NoiseMeter_H__593FCAE9_2DA3_4ABF_93A3_3F2D217BFCA8__INCLUDED_)
