// Calculator.cpp : implementation file
//
//(C) Copyright Dave Roberts G8KBB 2005
// This program is released only for the purpose of self training and eduation
// in amatuer radio. It may not be used for any commercial purpose, sold or
// modified.
// It has been written as an exercise in self tuition by me as part of my hobby
// and I make no claims about its fitness for purpose or correct operation.

#include "stdafx.h"
#include "NoiseMeter.h"
#include "Calculator.h"
#include "deviceNF.h"
#include "measure.h"

#include "mmsystem.h"

#include "spectrum.h"
#include "setup.h"

#include "common.h"

#include "math.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


// Pointers to other objects
extern spectrum *pSpectrum;
extern measure *pMeasure;
extern setup *pSetup;
extern deviceNF *pDeviceNF;

extern CFont fnMyFont24;


/////////////////////////////////////////////////////////////////////////////
// CCalculator property page

IMPLEMENT_DYNCREATE(CCalculator, CPropertyPage)

CCalculator::CCalculator() : CPropertyPage(CCalculator::IDD)
{
	//{{AFX_DATA_INIT(CCalculator)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	// registry location
	CString sSetup, sToken;
	sSetup.LoadString(IDS_STRING_SETUP);

	sToken.LoadString(IDS_TSOFF);
	CString szTemp = AfxGetApp( )->GetProfileString( sSetup, sToken, DEFAULT_TSOFF );
	dTSOffCalibrated = dTSOffTarget = atof( szTemp );

	sToken.LoadString(IDS_T0);
	szTemp = AfxGetApp( )->GetProfileString( sSetup, sToken, DEFAULT_T0 );
	dT0 = atof( szTemp );

	nCalcMode = CALC_SIMPLE;
	dEnrOrFrequency = 0;

	dTemp = dFigure = 0;
	dFactor = 1;

	dBandWidthKHz = 0.0;

	dENRdev = 0;

	nGotFocus = nPreviousFocus = 0;

	bGotReadings[0]= bGotReadings[1]= bGotReadings[2]= bGotReadings[3]= FALSE;
	bGainCalculated = FALSE;
	bEnrCalculated = FALSE;
}

CCalculator::~CCalculator()
{
}

void CCalculator::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCalculator)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCalculator, CPropertyPage)
	//{{AFX_MSG_MAP(CCalculator)
	ON_BN_CLICKED(IDC_RADIO_SIMPLE_CALC, OnRadioSimpleCalc)
	ON_BN_CLICKED(IDC_RADIO_Y_DEVICE, OnRadioYDevice)
	ON_BN_CLICKED(IDC_RADIO_Y_SYSTEM, OnRadioYSystem)
	ON_BN_CLICKED(IDC_RADIO_CAL_ENR, OnRadioCalEnr)
	ON_EN_CHANGE(IDC_EDIT_ENR, OnChangeEditEnr)
	ON_EN_CHANGE(IDC_EDIT_NTEMP, OnChangeEditNtemp)
	ON_EN_CHANGE(IDC_EDIT_NFACTOR, OnChangeEditNfactor)
	ON_EN_SETFOCUS(IDC_EDIT_NTEMP, OnSetfocusEditNtemp)
	ON_EN_KILLFOCUS(IDC_EDIT_NTEMP, OnKillfocusEditNtemp)
	ON_EN_SETFOCUS(IDC_EDIT_NFACTOR, OnSetfocusEditNfactor)
	ON_EN_KILLFOCUS(IDC_EDIT_NFACTOR, OnKillfocusEditNfactor)
	ON_EN_SETFOCUS(IDC_EDIT_NFIGURE, OnSetfocusEditNfigure)
	ON_EN_KILLFOCUS(IDC_EDIT_NFIGURE, OnKillfocusEditNfigure)
	ON_EN_CHANGE(IDC_EDIT_NFIGURE, OnChangeEditNfigure)
	ON_EN_CHANGE(IDC_EDIT_DEVICE_RXBW, OnChangeEditDeviceRxbw)
	ON_EN_CHANGE(IDC_EDIT_REF_ON, OnChangeEditRefOn)
	ON_EN_CHANGE(IDC_EDIT_REF_OFF, OnChangeEditRefOff)
	ON_EN_CHANGE(IDC_EDIT_DEVICE_ON, OnChangeEditDeviceOn)
	ON_EN_CHANGE(IDC_EDIT_DEVICE_OFF, OnChangeEditDeviceOff)
	ON_EN_CHANGE(IDC_EDIT_T_0, OnChangeEditT0)
	ON_EN_CHANGE(IDC_EDIT_TSOFF, OnChangeEditTsoff)
	ON_EN_CHANGE(IDC_EDIT_TSOFF2, OnChangeEditTsoff2)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCalculator message handlers

/////////////////////////////////////////////////////////////////////////////
// helper utility that changes on screen items according to mode

void CCalculator::SetControlsForMode()
{
	CWnd *pWnd;
//	CString sTemp;

	SET_STATE( IDC_STATIC_YFACTOR, nCalcMode != CALC_SIMPLE );
	SET_STATE( IDC_STATIC_CALON, nCalcMode != CALC_SIMPLE );
	SET_STATE( IDC_STATIC_CALOFF, nCalcMode != CALC_SIMPLE );
	SET_STATE( IDC_STATIC_DUT_ON, nCalcMode == CALC_Y_DEVICE || nCalcMode == CALC_ENR);
	SET_STATE( IDC_STATIC_DUT_OFF, nCalcMode == CALC_Y_DEVICE || nCalcMode == CALC_ENR );
	SET_STATE( IDC_EDIT_REF_ON, nCalcMode != CALC_SIMPLE );
	SET_STATE( IDC_EDIT_REF_OFF, nCalcMode != CALC_SIMPLE );
	SET_STATE( IDC_EDIT_DEVICE_ON, nCalcMode == CALC_Y_DEVICE || nCalcMode == CALC_ENR );
	SET_STATE( IDC_EDIT_DEVICE_OFF, nCalcMode == CALC_Y_DEVICE || nCalcMode == CALC_ENR );
	SET_STATE( IDC_EDIT_ENR, nCalcMode != CALC_SIMPLE );
	SET_STATE( IDC_EDIT_TSOFF, nCalcMode != CALC_SIMPLE );
	SET_STATE( IDC_EDIT_TSOFF2, nCalcMode == CALC_ENR );
	SET_STATE( IDC_STATIC_USE_F, nCalcMode != CALC_SIMPLE );
	SET_STATE( IDC_STATIC_ENR_FROM_F, nCalcMode != CALC_SIMPLE && pSetup->bUseEnrFile);
	SET_STATE( IDC_STATIC_REF_TSOFF, nCalcMode != CALC_SIMPLE );
	SET_STATE( IDC_STATIC_DUT_TSOFF, nCalcMode == CALC_ENR );
	SET_STATE( IDC_EDIT_GAIN, nCalcMode == CALC_Y_DEVICE || nCalcMode == CALC_ENR);
	SET_STATE( IDC_STATIC_GAIN, nCalcMode == CALC_Y_DEVICE || nCalcMode == CALC_ENR);
	SET_STATE( IDC_EDIT_NTEMP, nCalcMode == CALC_SIMPLE );
	SET_STATE( IDC_EDIT_NFACTOR, nCalcMode == CALC_SIMPLE );
	SET_STATE( IDC_EDIT_NFIGURE, nCalcMode == CALC_SIMPLE );
	SET_STATE( IDC_STATIC_NFIGURE, nCalcMode != CALC_ENR );
	SET_STATE( IDC_STATIC_NTEMP, nCalcMode != CALC_ENR );
	SET_STATE( IDC_STATIC_NFACTOR, nCalcMode != CALC_ENR );
	SET_STATE( IDC_STATIC_RXNFL, nCalcMode != CALC_ENR );

	SET_READONLY( IDC_EDIT_NTEMP, nCalcMode != CALC_SIMPLE );
	SET_READONLY( IDC_EDIT_NFACTOR, nCalcMode != CALC_SIMPLE );
	SET_READONLY( IDC_EDIT_NFIGURE, nCalcMode != CALC_SIMPLE );

	pWnd = GetDlgItem(IDC_RADIO_SIMPLE_CALC);
	ASSERT_VALID(pWnd);
	pWnd->SendMessage(BM_SETCHECK, nCalcMode == CALC_SIMPLE, 0);
	pWnd = GetDlgItem(IDC_RADIO_Y_SYSTEM);
	ASSERT_VALID(pWnd);
	pWnd->SendMessage(BM_SETCHECK, nCalcMode == CALC_Y_SYSTEM, 0);
	pWnd = GetDlgItem(IDC_RADIO_Y_DEVICE);
	ASSERT_VALID(pWnd);
	pWnd->SendMessage(BM_SETCHECK, nCalcMode == CALC_Y_DEVICE, 0);
	pWnd = GetDlgItem(IDC_RADIO_CAL_ENR);
	ASSERT_VALID(pWnd);
	pWnd->SendMessage(BM_SETCHECK, nCalcMode == CALC_ENR, 0);

	pWnd = GetDlgItem(IDC_STATIC_DUT_ON);
	ASSERT_VALID(pWnd);
	pWnd->SetWindowText( nCalcMode == CALC_Y_DEVICE ? "DUT in circuit and Noise source ON" : "Unknown noise source ON");

	pWnd = GetDlgItem(IDC_STATIC_DUT_OFF);
	ASSERT_VALID(pWnd);
	pWnd->SetWindowText( nCalcMode == CALC_Y_DEVICE ? "DUT in circuit and Noise source OFF" : "Unknown noise source OFF");

	pWnd = GetDlgItem(IDC_STATIC_GAIN);
	ASSERT_VALID(pWnd);
	pWnd->SetWindowText( nCalcMode == CALC_ENR ? "ENR (dB)" : "Gain (dB)");

}


/////////////////////////////////////////////////////////////////////////////
// The following 4 functions change the calculator mode

void CCalculator::OnRadioSimpleCalc() 
{
	// TODO: Add your control notification handler code here
	nCalcMode = CALC_SIMPLE;
	SetControlsForMode();
	ShowResultsBarOne(0);
}

void CCalculator::OnRadioYDevice() 
{
	// TODO: Add your control notification handler code here
	nCalcMode = CALC_Y_DEVICE;
	SetControlsForMode();
	compute_results();
	ShowResultsBarOne(0);
}

void CCalculator::OnRadioYSystem() 
{
	// TODO: Add your control notification handler code here
	nCalcMode = CALC_Y_SYSTEM;
	SetControlsForMode();
	compute_results();
	ShowResultsBarOne(0);
}

void CCalculator::OnRadioCalEnr() 
{
	// TODO: Add your control notification handler code here
	nCalcMode = CALC_ENR;
	SetControlsForMode();
	compute_results();
	ShowResultsBarOne(0);
}

/////////////////////////////////////////////////////////////////////////////
// initialisation and selection functions

BOOL CCalculator::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	ShowResultsBarOne( 0 );
	SetControlsForMode();	

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CCalculator::OnSetActive() 
{
	char sztemp[128];
	CString sTemp;

	CWnd *pWnd = GetDlgItem(IDC_EDIT_ENR);
	ASSERT_VALID(pWnd);
	sprintf( sztemp, "%.3f", pDeviceNF->dEnrOrFrequency);
	pWnd->SetWindowText( sztemp );

	pWnd = GetDlgItem(IDC_EDIT_TSOFF);
	ASSERT_VALID(pWnd);
	sprintf( sztemp, "%.2f", dTSOffCalibrated);
	pWnd->SetWindowText( sztemp );

	pWnd = GetDlgItem(IDC_EDIT_TSOFF2);
	ASSERT_VALID(pWnd);
	sprintf( sztemp, "%.2f", dTSOffTarget);
	pWnd->SetWindowText( sztemp );

	pWnd = GetDlgItem(IDC_EDIT_T_0);
	ASSERT_VALID(pWnd);
	sprintf( sztemp, "%.2f", dT0);
	pWnd->SetWindowText( sztemp );

	pWnd = GetDlgItem(IDC_STATIC_USE_F);
	ASSERT_VALID(pWnd);
	sTemp.LoadString( pSetup->bUseEnrFile ? IDS_STRINGNF_ENR_F : IDS_STRINGNF_ENR_DB );
	pWnd->SetWindowText(sTemp);

	return CPropertyPage::OnSetActive();
}

void CCalculator::OnChangeEditEnr() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CPropertyPage::OnInitDialog()
	// function to send the EM_SETEVENTMASK message to the control
	// with the ENM_CHANGE flag ORed into the lParam mask.
	
	char sztemp[128];

	CWnd *pWnd = GetDlgItem(IDC_EDIT_ENR);
	ASSERT_VALID(pWnd);
	pWnd->GetWindowText(sztemp, sizeof(sztemp));
	dEnrOrFrequency = atof( sztemp );
	dEnr = pSetup->ComputeENR( dEnrOrFrequency );

	pWnd = GetDlgItem(IDC_EDIT_ENR2);
	ASSERT_VALID(pWnd);
	if( pSetup->bUseEnrFile )
		sprintf( sztemp, "%.3f", dEnr);
	else
		sztemp[0] = 0;
	pWnd->SetWindowText( sztemp );
}

void CCalculator::OnChangeEditNtemp() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CPropertyPage::OnInitDialog()
	// function to send the EM_SETEVENTMASK message to the control
	// with the ENM_CHANGE flag ORed into the lParam mask.
	
	char sztemp[128];

	if( nGotFocus != IDC_EDIT_NTEMP )
		return;
	CWnd *pWnd = GetDlgItem(IDC_EDIT_NTEMP);
	ASSERT_VALID(pWnd);
	pWnd->GetWindowText(sztemp, sizeof(sztemp));
	dTemp = atof( sztemp );

	ShowResultsBarOne( IDC_EDIT_NTEMP );
}

void CCalculator::OnChangeEditNfactor() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CPropertyPage::OnInitDialog()
	// function to send the EM_SETEVENTMASK message to the control
	// with the ENM_CHANGE flag ORed into the lParam mask.
	
	char sztemp[128];

	if( nGotFocus != IDC_EDIT_NFACTOR)
		return;
	CWnd *pWnd = GetDlgItem(IDC_EDIT_NFACTOR);
	ASSERT_VALID(pWnd);
	pWnd->GetWindowText(sztemp, sizeof(sztemp));
	dFactor = atof( sztemp );

	ShowResultsBarOne( IDC_EDIT_NFACTOR );
}

void CCalculator::OnChangeEditNfigure() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CPropertyPage::OnInitDialog()
	// function to send the EM_SETEVENTMASK message to the control
	// with the ENM_CHANGE flag ORed into the lParam mask.
	
	char sztemp[128];

	if( nGotFocus != IDC_EDIT_NFIGURE)
		return;
	CWnd *pWnd = GetDlgItem(IDC_EDIT_NFIGURE);
	ASSERT_VALID(pWnd);
	pWnd->GetWindowText(sztemp, sizeof(sztemp));
	dFigure = atof( sztemp );

	ShowResultsBarOne( IDC_EDIT_NFIGURE );
}

/////////////////////////////////////////////////////////////////////////////
// This is a key function. It is used to display all current results.
// However it is possible to update all bar one value. This is used
// in simple calculator mode to allow one value to be vaied without
// changing the one being editied.
// Note also that values are recalculated as changes to things such as 
// T0 may need to be reflected in the results.

void CCalculator::ShowResultsBarOne( int nWhichOne )
{
	CWnd *pWnd;

	switch( nWhichOne )
	{
		case IDC_EDIT_NTEMP:
			dFactor = 1 + dTemp/dT0;
			dFigure = 10*log10( dFactor );
			break;
		case IDC_EDIT_NFACTOR:
			dTemp = (dFactor - 1) * dT0;
			dFigure = 10*log10( dFactor );
			break;
		case IDC_EDIT_NFIGURE:
			dFactor = pow( 10, dFigure / 10 );
			dTemp = (dFactor - 1) * dT0;
			break;
	}

	if( nWhichOne != IDC_EDIT_NTEMP )
	{
		pWnd = GetDlgItem(IDC_EDIT_NTEMP);
		ASSERT_VALID(pWnd);
		ShowReading( pWnd, dTemp < 0 || dTemp > T_LIMIT_K, dTemp, IDS_STRING_ERROR, &fnMyFont24, TRUE );
	}

	if( nWhichOne != IDC_EDIT_NFACTOR )
	{
		pWnd = GetDlgItem(IDC_EDIT_NFACTOR);
		ASSERT_VALID(pWnd);
		ShowReading( pWnd, dTemp < 0 || dTemp > T_LIMIT_K, dFactor, IDS_STRING_ERROR, &fnMyFont24, TRUE );
	}

	if( nWhichOne != IDC_EDIT_NFIGURE )
	{
		pWnd = GetDlgItem(IDC_EDIT_NFIGURE);
		ASSERT_VALID(pWnd);
		ShowReading( pWnd, dTemp < 0 || dTemp > T_LIMIT_K, dFigure, IDS_STRING_ERROR, &fnMyFont24, TRUE );
	}

	if( dBandWidthKHz != 0 && nWhichOne != IDC_EDIT_NFLOOR)
	{
		pWnd = GetDlgItem(IDC_EDIT_NFLOOR);
		ASSERT_VALID(pWnd);
		ShowReading( pWnd, dTemp < 0 || dTemp > T_LIMIT_K, 10*log10(BOLTZMANN*dT0*dBandWidthKHz*1000)+30+dFigure, IDS_STRING_ERROR, &fnMyFont24, TRUE );
	}

	pWnd = GetDlgItem(IDC_EDIT_GAIN);
	ASSERT_VALID(pWnd);
	pWnd->SetWindowText( "" );
	if( nCalcMode == CALC_Y_DEVICE && nWhichOne != IDC_EDIT_GAIN && bGainCalculated )
		ShowReading( pWnd, dTemp < 0 || dTemp > T_LIMIT_K, 10*log10(dGain), IDS_STRING_ERROR, &fnMyFont24, TRUE );
	if( nCalcMode == CALC_ENR && nWhichOne != IDC_EDIT_GAIN && bEnrCalculated)
		ShowReading( pWnd, dENRdev < 0 || dENRdev > ENR_LIMIT_DB, dENRdev, IDS_STRING_ERROR, &fnMyFont24, TRUE );
}

/////////////////////////////////////////////////////////////////////////////
// In the following set of functions we deal with the user selecting the
// noise temperature, figure or factor in simple calculator mode. We
// need to know where focus is (and was) for updates.

void CCalculator::OnSetfocusEditNtemp() 
{
	nGotFocus = IDC_EDIT_NTEMP;
}

void CCalculator::OnKillfocusEditNtemp() 
{
	nPreviousFocus = nGotFocus;
	nGotFocus = 0;
}


void CCalculator::OnSetfocusEditNfactor() 
{
	nGotFocus = IDC_EDIT_NFACTOR;
}

void CCalculator::OnKillfocusEditNfactor() 
{
	nPreviousFocus = nGotFocus;
	nGotFocus = 0;
}

void CCalculator::OnSetfocusEditNfigure() 
{
	nGotFocus = IDC_EDIT_NFIGURE;
}

void CCalculator::OnKillfocusEditNfigure() 
{
	nPreviousFocus = nGotFocus;
	nGotFocus = 0;
}


void CCalculator::OnChangeEditDeviceRxbw() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CPropertyPage::OnInitDialog()
	// function to send the EM_SETEVENTMASK message to the control
	// with the ENM_CHANGE flag ORed into the lParam mask.

	char sztemp[128];
	
	CWnd *pWnd = GetDlgItem(IDC_EDIT_DEVICE_RXBW);
	ASSERT_VALID(pWnd);
	pWnd->GetWindowText(sztemp, sizeof(sztemp));
	dBandWidthKHz = atof( sztemp );

	ShowResultsBarOne( 0 );
}

void CCalculator::OnChangeEditRefOn() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CPropertyPage::OnInitDialog()
	// function to send the EM_SETEVENTMASK message to the control
	// with the ENM_CHANGE flag ORed into the lParam mask.
	
	char sztemp[128];

	CWnd *pWnd = GetDlgItem(IDC_EDIT_REF_ON);
	ASSERT_VALID(pWnd);
	pWnd->GetWindowText(sztemp, sizeof(sztemp));
	dReadingsDB[0]= atof( sztemp );
	dReadings[0]= pow( 10, dReadingsDB[0]/10 );
	bGotReadings[0] = TRUE;

	compute_results();
	ShowResultsBarOne( 0 );
}

void CCalculator::OnChangeEditRefOff() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CPropertyPage::OnInitDialog()
	// function to send the EM_SETEVENTMASK message to the control
	// with the ENM_CHANGE flag ORed into the lParam mask.
	
	char sztemp[128];

	CWnd *pWnd = GetDlgItem(IDC_EDIT_REF_OFF);
	ASSERT_VALID(pWnd);
	pWnd->GetWindowText(sztemp, sizeof(sztemp));
	dReadingsDB[1]= atof( sztemp );
	dReadings[1]= pow( 10, dReadingsDB[1]/10 );
	bGotReadings[1] = TRUE;

	compute_results();
	ShowResultsBarOne( 0 );
}

void CCalculator::OnChangeEditDeviceOn() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CPropertyPage::OnInitDialog()
	// function to send the EM_SETEVENTMASK message to the control
	// with the ENM_CHANGE flag ORed into the lParam mask.
	
	char sztemp[128];

	CWnd *pWnd = GetDlgItem(IDC_EDIT_DEVICE_ON);
	ASSERT_VALID(pWnd);
	pWnd->GetWindowText(sztemp, sizeof(sztemp));
	dReadingsDB[2]= atof( sztemp );
	dReadings[2]= pow( 10, dReadingsDB[2]/10 );
	bGotReadings[2] = TRUE;

	compute_results();
	ShowResultsBarOne( 0 );
}

void CCalculator::OnChangeEditDeviceOff() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CPropertyPage::OnInitDialog()
	// function to send the EM_SETEVENTMASK message to the control
	// with the ENM_CHANGE flag ORed into the lParam mask.
	
	char sztemp[128];

	CWnd *pWnd = GetDlgItem(IDC_EDIT_DEVICE_OFF);
	ASSERT_VALID(pWnd);
	pWnd->GetWindowText(sztemp, sizeof(sztemp));
	dReadingsDB[3]= atof( sztemp );
	dReadings[3]= pow( 10, dReadingsDB[3]/10 );
	bGotReadings[3] = TRUE;

	compute_results();
	ShowResultsBarOne( 0 );
}

void CCalculator::compute_results()
{
	double dY12;	// Y factor computed for overall system
	double dT12;	// Noise temperature of overall system
	double dENRabs;	// ENR as a ratio (instead of dB)
	double dY2;		// Y factor computed for measuring system
	double dTSon;	// Noise temperature when noise source on
	double dT2;		// Noise temperature for measuring system
	double dYcal;
	double dYdev;
	double dENRcalAbs;

	switch( nCalcMode )
	{
	case CALC_SIMPLE:
		break;
	case CALC_Y_DEVICE:
		if( !bGotReadings[2] || !bGotReadings[3] )
			break;
	case CALC_Y_SYSTEM:
		if( !bGotReadings[0] || !bGotReadings[1] )
			break;
		dENRabs = pow((double)10,(dEnr/10));
		dY2 = dReadings[0]/dReadings[1];
		dTSon = dENRabs*dT0 + dTSOffCalibrated;
		dT2 = (dTSon - dY2*dTSOffCalibrated)/(dY2-1);

		// Skip calculation for DUT if measuring overall system
		if( nCalcMode == CALC_Y_SYSTEM )
		{
			dTemp = dT2;
		}
		else
		{
			dY12 = dReadings[2] / dReadings[3];
			dGain = ( dReadings[2] - dReadings[3] ) / (dReadings[0] - dReadings[1] );
			bGainCalculated = TRUE;
			dT12 = (dTSon - dY12*dTSOffCalibrated)/(dY12-1);
			dTemp = dT12 - dT2/dGain;
		}
		// calculate results (noise factor, figure and gain in dB)
		dFactor = 1 + dTemp/dT0;
		dFigure = 10* log10(dFactor);
		break;
	case CALC_ENR:
		if( bGotReadings[0] && bGotReadings[1] && 
			bGotReadings[2] && bGotReadings[3] )
		{
			dENRcalAbs = pow((double)10,(dEnr/10));
			dYcal = dReadings[0]/dReadings[1];
			dYdev = dReadings[2]/dReadings[3];
			bEnrCalculated = TRUE;
			dENRdev = 10*log10((dYdev-1)*(dENRcalAbs/(dYcal-1)-(dTSOffTarget-dTSOffCalibrated)/pDeviceNF->dT0));
		}
		break;
	}
}

void CCalculator::OnChangeEditT0() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CPropertyPage::OnInitDialog()
	// function to send the EM_SETEVENTMASK message to the control
	// with the ENM_CHANGE flag ORed into the lParam mask.

	char sztemp[128];
	
	CWnd *pWnd = GetDlgItem(IDC_EDIT_T_0);
	ASSERT_VALID(pWnd);
	pWnd->GetWindowText(sztemp, sizeof(sztemp));
	dT0= atof( sztemp );
	compute_results();
	ShowResultsBarOne( nPreviousFocus );
}

void CCalculator::OnChangeEditTsoff() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CPropertyPage::OnInitDialog()
	// function to send the EM_SETEVENTMASK message to the control
	// with the ENM_CHANGE flag ORed into the lParam mask.
	
	char sztemp[128];

	CWnd *pWnd = GetDlgItem(IDC_EDIT_TSOFF);
	ASSERT_VALID(pWnd);
	pWnd->GetWindowText(sztemp, sizeof(sztemp));
	dTSOffCalibrated = atof( sztemp );
	compute_results();
	ShowResultsBarOne( 0 );
}

void CCalculator::OnChangeEditTsoff2() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CPropertyPage::OnInitDialog()
	// function to send the EM_SETEVENTMASK message to the control
	// with the ENM_CHANGE flag ORed into the lParam mask.
	
	char sztemp[128];

	CWnd *pWnd = GetDlgItem(IDC_EDIT_TSOFF2);
	ASSERT_VALID(pWnd);
	pWnd->GetWindowText(sztemp, sizeof(sztemp));
	dTSOffTarget = atof( sztemp );
	compute_results();
	ShowResultsBarOne( 0 );
}
