// high-pass-filters.cpp : implementation file

// These filters were generated by the excellent website of Tony Fisher
// One of the easiest ways to generate a digital filter I have seen !
// http://www-users.cs.york.ac.uk/~fisher/mkfilter

/* Digital filter designed by mkfilter/mkshape/gencode   A.J. Fisher
   Command line: /www/usr/fisher/helpers/mkfilter -Bu -Hp -o 5 -a 2.0833333333e-02 0.0000000000e+00 -l */

//(C) Copyright Dave Roberts G8KBB 2005
// This program is released only for the purpose of self training and eduation
// in amatuer radio. It may not be used for any commercial purpose, sold or
// modified.
// It has been written as an exercise in self tuition by me as part of my hobby
// and I make no claims about its fitness for purpose or correct operation.


#include "stdafx.h"
#include "high-pass-filters.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// ********************************************************************************
// filter definitions

#define NZEROS 5
#define NPOLES 5
#define GAIN96000	1.111736769e+00
#define GAIN48000   1.236132221e+00
#define GAIN44100	1.259572272e+00
#define GAIN22050	1.588837465e+00
#define GAIN11025	2.554779586e+00

// ********************************************************************************
// persistent storage for filters

double xv[NZEROS+1] = { (double)0 };
double yv[NPOLES+1] = { (double)0 };

// ********************************************************************************
// to speed up processing, vector to the appropriate filter using SetFilterRate

double (*pFilter)(double in);

// ********************************************************************************
// initialise persistent storage in an attenpt to avoid transient effects
// on IIR filter

void FilterInit( double in )
{
	int i;
	for(i=0;i<=NZEROS;i++)
		xv[i] = yv[i] = in;
}

// ********************************************************************************
// given a baud rate, select the appropriate filter

void SetFilterRate( int rate )
{
	switch( rate )
	{
	case 11025:
		pFilter = &filter11025;
		break;
	case 22050:
		pFilter = &filter22050;
		break;
	case 44100:
		pFilter = &filter44100;
		break;
	case 48000:
		pFilter = &filter48000;
		break;
	case 96000:
		pFilter = &filter96000;
		break;
	default:
		pFilter = &filter96000;
		ASSERT( FALSE );
		break;
	}
}

// ********************************************************************************
// the follwoing are identical 5 pole IIR high pass filters with
// 1000 Hz corner frequencies

double filter96000(double in)
  { 
       xv[0] = xv[1]; xv[1] = xv[2]; xv[2] = xv[3]; xv[3] = xv[4]; xv[4] = xv[5]; 
        xv[5] = in / GAIN96000;
        yv[0] = yv[1]; yv[1] = yv[2]; yv[2] = yv[3]; yv[3] = yv[4]; yv[4] = yv[5]; 
        yv[5] =   (xv[5] - xv[0]) + 5 * (xv[1] - xv[4]) + 10 * (xv[3] - xv[2])
                     + (  0.8090885611 * yv[0]) + ( -4.2167989742 * yv[1])
                     + (  8.7945960760 * yv[2]) + ( -9.1750976076 * yv[3])
                     + (  4.7882108624 * yv[4]);
        return yv[5];
      
  }


double filter48000(double in)
{
     xv[0] = xv[1]; xv[1] = xv[2]; xv[2] = xv[3]; xv[3] = xv[4]; xv[4] = xv[5]; 
        xv[5] = in / GAIN48000;
        yv[0] = yv[1]; yv[1] = yv[2]; yv[2] = yv[3]; yv[3] = yv[4]; yv[4] = yv[5]; 
        yv[5] =   (xv[5] - xv[0]) + 5 * (xv[1] - xv[4]) + 10 * (xv[3] - xv[2])
                     + (  0.6544404672 * yv[0]) + ( -3.5493660720 * yv[1])
                     + (  7.7126555779 * yv[2]) + ( -8.3942487601 * yv[3])
                     + (  4.5764874733 * yv[4]);
        return yv[5];
     
}


double filter44100(double in)
  { 
       xv[0] = xv[1]; xv[1] = xv[2]; xv[2] = xv[3]; xv[3] = xv[4]; xv[4] = xv[5]; 
        xv[5] = in / GAIN44100;
        yv[0] = yv[1]; yv[1] = yv[2]; yv[2] = yv[3]; yv[3] = yv[4]; yv[4] = yv[5]; 
        yv[5] =   (xv[5] - xv[0]) + 5 * (xv[1] - xv[4]) + 10 * (xv[3] - xv[2])
                     + (  0.6303094476 * yv[0]) + ( -3.4420874194 * yv[1])
                     + (  7.5333403772 * yv[2]) + ( -8.2606609327 * yv[3])
                     + (  4.5390515205 * yv[4]);
        return yv[5];
      
  }


double filter22050(double in)
  { 
       xv[0] = xv[1]; xv[1] = xv[2]; xv[2] = xv[3]; xv[3] = xv[4]; xv[4] = xv[5]; 
        xv[5] = in / GAIN22050;
        yv[0] = yv[1]; yv[1] = yv[2]; yv[2] = yv[3]; yv[3] = yv[4]; yv[4] = yv[5]; 
        yv[5] =   (xv[5] - xv[0]) + 5 * (xv[1] - xv[4]) + 10 * (xv[3] - xv[2])
                     + (  0.3961330287 * yv[0]) + ( -2.3455968096 * yv[1])
                     + (  5.5947463682 * yv[2]) + ( -6.7252708414 * yv[3])
                     + (  4.0787649342 * yv[4]);
        return yv[5];
      
  }

double filter11025(double in)
  { 
       xv[0] = xv[1]; xv[1] = xv[2]; xv[2] = xv[3]; xv[3] = xv[4]; xv[4] = xv[5]; 
        xv[5] = in / GAIN11025;
        yv[0] = yv[1]; yv[1] = yv[2]; yv[2] = yv[3]; yv[3] = yv[4]; yv[4] = yv[5]; 
        yv[5] =   (xv[5] - xv[0]) + 5 * (xv[1] - xv[4]) + 10 * (xv[3] - xv[2])
                     + (  0.1532114086 * yv[0]) + ( -1.0476163381 * yv[1])
                     + (  2.9336780567 * yv[2]) + ( -4.2286611190 * yv[3])
                     + (  3.1623754658 * yv[4]);
        return yv[5];
      
  }



