// NoiseMeter.cpp : Defines the class behaviors for the application.
//
//(C) Copyright Dave Roberts G8KBB 2005
// This program is released only for the purpose of self training and eduation
// in amatuer radio. It may not be used for any commercial purpose, sold or
// modified.
// It has been written as an exercise in self tuition by me as part of my hobby
// and I make no claims about its fitness for purpose or correct operation.

#include "stdafx.h"
#include "NoiseMeter.h"

#include "spectrum.h"
#include "measure.h"
#include "setup.h"
#include "deviceNF.h"
#include "CalibrateNoiseSource.h"
#include "Calculator.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern BOOL StopInput();

/////////////////////////////////////////////////////////////////////////////
// Global pointers to allow access between 6 main parts

spectrum *pSpectrum;
measure *pMeasure;
setup *pSetup;
deviceNF *pDeviceNF;
CCalibrateNoiseSource *pCalibrateNoiseSource;
CCalculator *pCalculator;

/////////////////////////////////////////////////////////////////////////////
// CNoiseMeterApp

BEGIN_MESSAGE_MAP(CNoiseMeterApp, CWinApp)
	//{{AFX_MSG_MAP(CNoiseMeterApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNoiseMeterApp construction

CNoiseMeterApp::CNoiseMeterApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
	pSpectrum = NULL;
	pMeasure = NULL;
	pSetup = NULL;
	pDeviceNF = NULL;
	pCalibrateNoiseSource = NULL;
	pCalculator = NULL;
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CNoiseMeterApp object

CNoiseMeterApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CNoiseMeterApp initialization

BOOL CNoiseMeterApp::InitInstance()
{
	AfxEnableControlContainer();

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	// of your final executable, you should remove from the following
	// the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// Setup registry access for configuration changes
	CString strCurr;
	strCurr.LoadString(IDS_STRINGRegKey);
	SetRegistryKey( strCurr );
	

	// create property sheet.
	// We have 6 pages, and for each we have a globally accessible pointer
	// to allow access from elsewhere.

	pSetup = new setup;
	pSpectrum = new spectrum;
	pMeasure = new measure;
	pDeviceNF = new deviceNF;
	pCalibrateNoiseSource = new CCalibrateNoiseSource;
	pCalculator = new CCalculator;
	dlg.AddPage(pMeasure);
	dlg.AddPage(pDeviceNF);
	dlg.AddPage(pSpectrum);
	dlg.AddPage(pCalibrateNoiseSource);
	dlg.AddPage(pCalculator);
	dlg.AddPage(pSetup);
	m_pMainWnd = &dlg;

    HICON Icon=LoadIcon(IDR_MAINFRAME);
    dlg.m_psh.dwFlags|=PSH_USEHICON;
    dlg.m_psh.hIcon=Icon;

	dlg.SetTitle("Noise Meter");

 	dlg.Create(NULL,WS_SYSMENU|WS_POPUP|WS_CAPTION|DS_MODALFRAME|WS_VISIBLE|WS_MINIMIZEBOX);

    CMenu *pSysMenu = dlg.GetSystemMenu(FALSE);
    ASSERT(pSysMenu != NULL);
    VERIFY(pSysMenu->RemoveMenu(SC_MAXIMIZE, MF_BYCOMMAND)); 
    VERIFY(pSysMenu->RemoveMenu(SC_SIZE, MF_BYCOMMAND)); 

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Setup initialisation will set this to '-1' if no valid device
	// stored in registry - so force setup page.
	// Otherwise start on measure page.

	if( pSetup->m_uWaveInDev < 0 )
	{
		pSetup->m_uWaveInDev = 0;
		dlg.SetActivePage( pSetup );
	}
	if( pSetup->m_uWaveInFormat < 0 )
	{
		pSetup->m_uWaveInFormat = 0;
		dlg.SetActivePage( pSetup );
	}

	return TRUE;
}

int CNoiseMeterApp::ExitInstance() 
{
	// TODO: Add your specialized code here and/or call the base class
	StopInput();
	if( pSetup != NULL )
		delete pSetup;
	if( pSpectrum != NULL )
		delete pSpectrum;
	if( pMeasure != NULL )
		delete pMeasure;
	if( pDeviceNF != NULL )
		delete pDeviceNF;
	if( pCalibrateNoiseSource != NULL )
		delete pCalibrateNoiseSource;
	if( pCalculator != NULL )
		delete pCalculator;

	return CWinApp::ExitInstance();
}
