// CustomVNAinterfaceDLL.h

// this file includes definitions for the custom VNA interface DLL
// it must match the one used by myVNA so don't change definitions !

#pragma once

// do not change these definitions - they relate to the interpretation of return values by myVNA
// error flags used in USB and TCPIP comms
//
// ADC Read flags (also explicitly returned from CheckVNAReady and RescanForVNA)
#define VNAHW_NONETCONNECT (1<<10)
#define ADC_SAME (1<<9)
#define ADC_OVERRANGE (1<<8)
#define ADC_READ_TIMEOUT (1<<7)
#define VNA_NO_POWER (1<<6)
#define ADC_START_FLAG (1<<4)
#define ADC_NOT_RESPONDING (1<<3)
#define ADC_DATA_READY (1<<5)
// return codes from Read, Command and Reset functions
#define VNAHW_OK	0
#define VNAHW_HWERROR	1
// the above are also returned as error codes from DoScan, along with the following
#define VNAHW_OVERRANGE 2
#define VNAHW_ADC_TIMEOUT 3
#define VNAHW_NO_POWER 4
// from MSA scan functions
#define VNAHW_INVALID_ADC 5
#define VNAHW_COMMSERROR 6

// These are the exported functions called by myVNA.
// Call CustomVNAhwInit() before anything else
// Call CustomVNAhwFree() before closing
// Pass the value returned by CustomVNAhwInit() as the first parameter to all other functions
// see the c++ source for details of each function

__declspec(dllexport) void *_stdcall CustomVNAhwInit(int nInstance);
__declspec(dllexport) void _stdcall CustomVNAhwFree(void *pHelper);
__declspec(dllexport) bool _stdcall CheckVNAHardware(void *pHelper);
__declspec(dllexport) bool _stdcall RescanForCustomVNA(void *pHelper, int nInstance);
__declspec(dllexport) bool _stdcall GetCustomVNACodeVersions(void *pHelper, int *pCustomVNAinterfaceDLLversion, int *pVnaDllVersion, int *pUSBCodeVersion );
__declspec(dllexport) int _stdcall CustomVNACommand(void *pHelper, double dClockDDS, double LoDDS, double RfDDS, int LoPhase, int RfPhase, int Delay, 
													int AdcCount, int AdcMode, bool bPauseInOut, bool bOverlapDDSandADCFlag, bool bAdcOnly );
__declspec(dllexport) int _stdcall CustomVNARead(void *pHelper, int *pflags, int *pcount, signed long *pdata);
__declspec(dllexport) int _stdcall CheckCustomVNAReady(void *pHelper, int nInstance);
__declspec(dllexport) int _stdcall PowerDownCustomVNA(void *pHelper);
__declspec(dllexport) int _stdcall ResetCustomVNA(void *pHelper);
__declspec(dllexport) int _stdcall CustomVNASweep(void *pHelper, double dClockDDS, double dLoDDS, double dRfDDS, int LoPhase, int RfPhase,
												  double dLoStepDDS, double dRfStepDDS, int LoStepPhase, int RfStepPhase, 
												  int nSteps, int nStepDelay, int nInitDelay, bool SetSW1, bool bPowerDownBetweenSweeps);
__declspec(dllexport) int _stdcall SetCustomVNASwitchLines(void *pHelper, int nSetting );
__declspec(dllexport) int _stdcall SetCustomVNAAttenuatorLines(void *pHelper, int nSetting );
__declspec(dllexport) int _stdcall SetCustomVNAPortABLines(void *pHelper, int nSettingA, int nSettingB );
__declspec(dllexport) int _stdcall CustomVNARawRead(void *pHelper, int *dataA, int *dataB);
__declspec(dllexport) int _stdcall CustomVNAGetInformation(void *pHelper, int StructVersion, int StructSize, int what, void *pResult);

